/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.lobobrowser.primary.gui.CheckBoxPanel;
import org.lobobrowser.primary.gui.FieldType;
import org.lobobrowser.primary.gui.FormField;
import org.lobobrowser.primary.gui.FormPanel;
import org.lobobrowser.primary.gui.StringListControl;
import org.lobobrowser.primary.gui.SwingTasks;
import org.lobobrowser.primary.gui.prefs.AbstractSettingsUI;
import org.lobobrowser.settings.GeneralSettings;

public class GeneralSettingsUI
extends AbstractSettingsUI {
    private static final long serialVersionUID = 1L;
    private final GeneralSettings settings = GeneralSettings.getInstance();
    private final FormField ieVersionField = new FormField(FieldType.TEXT, "MSIE Version:");
    private final FormField mozillaVersionField = new FormField(FieldType.TEXT, "Mozilla Version:");
    private final CheckBoxPanel ieSpoofPanel;
    private final FormPanel mozPanel;
    private final FormPanel iePanel;
    private final StringListControl startupPagesStringListControl;
    private static final int MAX_STARTUP_PAGES = 4;

    public GeneralSettingsUI() {
        FormPanel iePanel;
        this.mozillaVersionField.setToolTip("Mozilla compatibility version.");
        this.iePanel = iePanel = new FormPanel();
        iePanel.addField(this.ieVersionField);
        iePanel.setBorder(new EmptyBorder(1, 8, 8, 0));
        this.ieSpoofPanel = new CheckBoxPanel("Include \"MSIE\" in User-Agent header.", iePanel);
        this.mozPanel = new FormPanel();
        this.mozPanel.addField(this.mozillaVersionField);
        this.startupPagesStringListControl = new StringListControl();
        this.startupPagesStringListControl.setEditListCaption("You may provide up to 4 startup URLs, one per line.");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getStartupGroupBox());
        this.add(Box.createRigidArea(new Dimension(8, 8)));
        this.add(this.getUserAgentGroupBox());
        this.add(SwingTasks.createVerticalFill());
        this.loadSettings();
        this.ieSpoofPanel.updateEnabling();
    }

    private Component getStartupGroupBox() {
        Box startupGroupBox = new Box(1);
        startupGroupBox.setBorder(new TitledBorder(new EtchedBorder(), "Startup"));
        Box startupPagesBox = new Box(0);
        JLabel pagesLabel = new JLabel("Pages:");
        pagesLabel.setToolTipText("Up to 4 pages launched when you first run the browser.");
        startupPagesBox.add(pagesLabel);
        startupPagesBox.add(this.startupPagesStringListControl);
        startupGroupBox.add(startupPagesBox);
        return startupGroupBox;
    }

    private Component getUserAgentGroupBox() {
        JPanel groupBox = new JPanel();
        groupBox.setPreferredSize(new Dimension(400, 100));
        groupBox.setLayout(new BoxLayout(groupBox, 1));
        groupBox.setBorder(new TitledBorder(new EtchedBorder(), "User Agent"));
        groupBox.add(this.getIECheckBoxPanel());
        groupBox.add(this.getMozVersionPanel());
        return groupBox;
    }

    private Component getIECheckBoxPanel() {
        return this.ieSpoofPanel;
    }

    private Component getMozVersionPanel() {
        return this.mozPanel;
    }

    @Override
    public void restoreDefaults() {
        this.settings.restoreDefaults();
        this.loadSettings();
    }

    @Override
    public void save() {
        GeneralSettings settings = this.settings;
        settings.setSpoofIE(this.ieSpoofPanel.isSelected());
        settings.setIeVersion(this.ieVersionField.getValue());
        settings.setMozVersion(this.mozillaVersionField.getValue());
        settings.setStartupURLs(this.startupPagesStringListControl.getStrings());
        settings.save();
    }

    private void loadSettings() {
        GeneralSettings settings = this.settings;
        this.ieSpoofPanel.setSelected(settings.isSpoofIE());
        this.ieVersionField.setValue(settings.getIeVersion());
        this.mozillaVersionField.setValue(settings.getMozVersion());
        this.mozPanel.revalidate();
        this.iePanel.revalidate();
        this.startupPagesStringListControl.setStrings(settings.getStartupURLs());
    }
}

