/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lobobrowser.primary.gui.FieldType;
import org.lobobrowser.primary.gui.FormField;
import org.lobobrowser.primary.gui.FormPanel;
import org.lobobrowser.primary.gui.SwingTasks;
import org.lobobrowser.primary.gui.ValidationException;
import org.lobobrowser.primary.gui.prefs.AbstractSettingsUI;
import org.lobobrowser.settings.ConnectionSettings;

public class ConnectionSettingsUI
extends AbstractSettingsUI {
    private static final long serialVersionUID = 1L;
    private final ConnectionSettings settings = ConnectionSettings.getInstance();
    private final JRadioButton noProxyRadioButton = new JRadioButton();
    private final JRadioButton httpProxyRadioButton = new JRadioButton();
    private final JRadioButton socksProxyRadioButton = new JRadioButton();
    private final JCheckBox authenticatedCheckBox = new JCheckBox();
    private final JCheckBox bypassLocalCheckBox = new JCheckBox();
    private final Box proxyHostArea = new Box(1);
    private final FormPanel authenticationPanel = new FormPanel();
    private final FormField userNameField = new FormField(FieldType.TEXT);
    private final FormField passwordField = new FormField(FieldType.PASSWORD);
    private final FormPanel hostPortPanel = new FormPanel();
    private final FormField hostField = new FormField(FieldType.TEXT);
    private final FormField portField = new FormField(FieldType.TEXT);

    public ConnectionSettingsUI() {
        this.noProxyRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConnectionSettingsUI.this.updateEnabling();
            }
        });
        this.authenticatedCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConnectionSettingsUI.this.updateEnabling();
            }
        });
        this.noProxyRadioButton.setText("Direct connection (no proxy)");
        this.httpProxyRadioButton.setText("HTTP proxy");
        this.socksProxyRadioButton.setText("SOCKS proxy");
        this.authenticatedCheckBox.setText("Authenticate with proxy server.");
        this.bypassLocalCheckBox.setText("Bypass proxy for local addresses.");
        this.userNameField.setCaption("User name:");
        this.passwordField.setCaption("Password:");
        this.authenticationPanel.addField(this.userNameField);
        this.authenticationPanel.addField(this.passwordField);
        this.hostField.setCaption("Host:");
        this.portField.setCaption("Port:");
        this.hostPortPanel.addField(this.hostField);
        this.hostPortPanel.addField(this.portField);
        ButtonGroup group = new ButtonGroup();
        group.add(this.noProxyRadioButton);
        group.add(this.httpProxyRadioButton);
        group.add(this.socksProxyRadioButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(8, 8)));
        this.add(this.getProxyBox());
        this.add(SwingTasks.createVerticalFill());
        this.loadSettings();
        this.updateEnabling();
    }

    private void updateEnabling() {
        SwingTasks.setNestedEnabled(this.proxyHostArea, !this.noProxyRadioButton.isSelected());
        SwingTasks.setNestedEnabled(this.authenticationPanel, this.authenticatedCheckBox.isSelected());
    }

    private Component getProxyBox() {
        Box radioBox = new Box(1);
        radioBox.setPreferredSize(new Dimension(600, 200));
        radioBox.add(this.noProxyRadioButton);
        radioBox.add(this.httpProxyRadioButton);
        radioBox.add(this.socksProxyRadioButton);
        Box radioBoxExpander = new Box(0);
        radioBoxExpander.add(radioBox);
        radioBoxExpander.add(Box.createGlue());
        Box box = SwingTasks.createGroupBox(1, "Proxy");
        box.add(radioBoxExpander);
        box.add(this.getProxyHostArea());
        return box;
    }

    private Component getProxyHostArea() {
        Box checkBoxBox = new Box(1);
        checkBoxBox.setPreferredSize(new Dimension(600, 200));
        checkBoxBox.add(this.bypassLocalCheckBox);
        checkBoxBox.add(this.authenticatedCheckBox);
        Box checkBoxBoxExpander = new Box(0);
        checkBoxBoxExpander.add(checkBoxBox);
        checkBoxBoxExpander.add(Box.createHorizontalGlue());
        Box box = this.proxyHostArea;
        box.setBorder(new EmptyBorder(8, 16, 8, 8));
        box.add(this.hostPortPanel);
        box.add(checkBoxBoxExpander);
        box.add(this.authenticationPanel);
        return box;
    }

    @Override
    public void restoreDefaults() {
        this.settings.restoreDefaults();
        this.loadSettings();
    }

    @Override
    public void save() throws ValidationException {
        int port;
        Proxy.Type proxyType;
        ConnectionSettings settings = this.settings;
        if (this.noProxyRadioButton.isSelected()) {
            proxyType = Proxy.Type.DIRECT;
        } else if (this.httpProxyRadioButton.isSelected()) {
            proxyType = Proxy.Type.HTTP;
        } else if (this.socksProxyRadioButton.isSelected()) {
            proxyType = Proxy.Type.SOCKS;
        } else {
            throw new IllegalStateException("not expected");
        }
        settings.setProxyType(proxyType);
        settings.setAuthenticated(this.authenticatedCheckBox.isSelected());
        settings.setUserName(this.userNameField.getValue());
        settings.setPassword(this.passwordField.getValue());
        settings.setDisableProxyForLocalAddresses(this.bypassLocalCheckBox.isSelected());
        String host = this.hostField.getValue();
        if ("".equals(host) && proxyType != Proxy.Type.DIRECT) {
            throw new ValidationException("To set up a proxy, a host name must be provided.");
        }
        try {
            port = Integer.parseInt(this.portField.getValue());
        }
        catch (NumberFormatException nfe) {
            if (proxyType != Proxy.Type.DIRECT) {
                throw new ValidationException("The port must be a number.");
            }
            port = 0;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        settings.setInetSocketAddress(socketAddress);
        settings.save();
    }

    private void loadSettings() {
        ConnectionSettings settings = this.settings;
        switch (settings.getProxyType()) {
            case DIRECT: {
                this.noProxyRadioButton.setSelected(true);
                break;
            }
            case HTTP: {
                this.httpProxyRadioButton.setSelected(true);
                break;
            }
            case SOCKS: {
                this.socksProxyRadioButton.setSelected(true);
            }
        }
        this.authenticatedCheckBox.setSelected(settings.isAuthenticated());
        this.userNameField.setValue(settings.getUserName());
        this.passwordField.setValue(settings.getPassword());
        this.bypassLocalCheckBox.setSelected(settings.isDisableProxyForLocalAddresses());
        InetSocketAddress socketAddress = settings.getInetSocketAddress();
        if (socketAddress == null) {
            this.hostField.setValue("");
            this.portField.setValue("");
        } else {
            this.hostField.setValue(socketAddress.getHostName());
            this.portField.setValue(String.valueOf(socketAddress.getPort()));
        }
        this.authenticationPanel.revalidate();
        this.hostPortPanel.revalidate();
    }
}

