/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lobobrowser.primary.gui.FormField;

public class FormPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final Collection<FormField> fields = new ArrayList<FormField>();
    private boolean fieldsInvalid = false;
    private int minLabelWidth = 0;

    public FormPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void addField(FormField field) {
        this.fields.add(field);
        this.fieldsInvalid = true;
    }

    @Override
    public void revalidate() {
        this.fieldsInvalid = true;
        super.revalidate();
    }

    public int getMinLabelWidth() {
        return this.minLabelWidth;
    }

    public void setMinLabelWidth(int minLabelWidth) {
        this.minLabelWidth = minLabelWidth;
    }

    private void populateComponents() {
        this.removeAll();
        int maxWidth = this.minLabelWidth;
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        boolean firstTime = true;
        for (FormField field : this.fields) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.add(Box.createRigidArea(new Dimension(1, 4)));
            }
            JLabel label = field.getLabel();
            label.setEnabled(this.isEnabled());
            labels.add(label);
            label.setHorizontalAlignment(4);
            String tooltip = field.getToolTip();
            if (tooltip != null) {
                label.setToolTipText(tooltip);
            }
            Dimension prefSize = label.getPreferredSize();
            if (prefSize.width > maxWidth) {
                maxWidth = prefSize.width;
            }
            JPanel entryPanel = new JPanel();
            entryPanel.setOpaque(false);
            entryPanel.setLayout(new BoxLayout(entryPanel, 0));
            entryPanel.add(label);
            entryPanel.add(Box.createRigidArea(new Dimension(4, 1)));
            JComponent editor = field.getFieldEditor();
            ((Component)editor).setEnabled(this.isEnabled());
            entryPanel.add(editor);
            Dimension epps = entryPanel.getPreferredSize();
            entryPanel.setPreferredSize(new Dimension(100, epps.height));
            this.add(entryPanel);
        }
        for (JLabel label : labels) {
            Dimension psize = label.getPreferredSize();
            Dimension newSize = new Dimension(maxWidth, psize.height);
            label.setPreferredSize(newSize);
            label.setMinimumSize(newSize);
            label.setMaximumSize(newSize);
        }
        this.fieldsInvalid = false;
    }

    @Override
    public void doLayout() {
        if (this.fieldsInvalid) {
            this.populateComponents();
        }
        super.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fieldsInvalid) {
            this.populateComponents();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.fieldsInvalid) {
            this.populateComponents();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.fieldsInvalid) {
            this.populateComponents();
        }
        return super.getMaximumSize();
    }
}

