/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.lobobrowser.gui.DefaultWindowFactory;
import org.lobobrowser.primary.action.TextViewerCloseAction;
import org.lobobrowser.primary.action.TextViewerCopyAction;
import org.lobobrowser.primary.action.TextViewerFindAction;
import org.lobobrowser.primary.action.TextViewerSelectAllAction;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.util.gui.WrapperLayout;

public class TextViewerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private NavigatorWindow window;
    private final JTextArea textArea;
    private boolean scrollsOnAppends;
    private DocumentListener cachedListener;

    public TextViewerWindow(NavigatorWindow window) {
        super("Lobo Text Viewer");
        JTextArea textArea;
        this.window = window;
        this.setIconImage(DefaultWindowFactory.getInstance().getDefaultImageIcon().getImage());
        JMenuBar menuBar = this.createMenuBar();
        this.setJMenuBar(menuBar);
        Container contentPane = this.getContentPane();
        this.textArea = textArea = this.createTextArea();
        contentPane.setLayout(WrapperLayout.getInstance());
        contentPane.add(new JScrollPane(textArea));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Document prevDocument;
                DocumentListener cl = TextViewerWindow.this.cachedListener;
                if (cl != null && (prevDocument = textArea.getDocument()) != null) {
                    prevDocument.removeDocumentListener(cl);
                }
            }
        });
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void setScrollsOnAppends(boolean flag) {
        this.scrollsOnAppends = flag;
    }

    private DocumentListener getDocumentListener() {
        DocumentListener cl = this.cachedListener;
        if (cl == null) {
            this.cachedListener = cl = new LocalDocumentListener();
        }
        return cl;
    }

    public void setSwingDocument(Document document) {
        Document prevDocument = this.textArea.getDocument();
        DocumentListener listener = this.getDocumentListener();
        if (prevDocument != null) {
            prevDocument.removeDocumentListener(listener);
        }
        document.addDocumentListener(listener);
        this.textArea.setDocument(document);
    }

    private JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        return textArea;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(ComponentSource.menuItem("Close", 'C', new TextViewerCloseAction(this)));
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu fileMenu = new JMenu("Edit");
        fileMenu.setMnemonic('E');
        fileMenu.add(ComponentSource.menuItem("Copy", 'C', "ctrl c", (Action)new TextViewerCopyAction(this)));
        fileMenu.add(ComponentSource.menuItem("Select All", 'A', "ctrl a", (Action)new TextViewerSelectAllAction(this)));
        fileMenu.add(ComponentSource.menuItem("Find", 'F', "ctrl f", (Action)new TextViewerFindAction(this, this.window)));
        return fileMenu;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    private class LocalDocumentListener
    implements DocumentListener {
        private LocalDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TextViewerWindow.this.scrollsOnAppends) {
                        TextViewerWindow.this.textArea.scrollRectToVisible(new Rectangle(0, Short.MAX_VALUE, 1, Short.MAX_VALUE));
                    }
                }
            });
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }
}

