/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.primary.ext.BaseHistory;
import org.lobobrowser.primary.ext.BookmarkInfo;
import org.lobobrowser.store.StorageManager;

public class BookmarksHistory
extends BaseHistory<BookmarkInfo>
implements Serializable {
    private static final long serialVersionUID = 2257845000200000300L;
    private static final Logger logger = Logger.getLogger(BookmarksHistory.class.getName());
    private static final BookmarksHistory instance;

    private BookmarksHistory() {
    }

    public static BookmarksHistory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        BookmarksHistory bookmarksHistory = this;
        synchronized (bookmarksHistory) {
            try {
                StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName(), ioe);
            }
        }
    }

    static {
        BookmarksHistory ins = null;
        try {
            ins = (BookmarksHistory)StorageManager.getInstance().retrieveSettings(BookmarksHistory.class.getSimpleName(), BookmarksHistory.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new BookmarksHistory();
        }
        instance = ins;
    }
}

