/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import org.lobobrowser.gui.NavigatorWindowImpl;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.FrameNode;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLAnchorElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.w3c.HTMLAnchorElement;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.primary.clientlets.html.BrowserFrameImpl;
import org.lobobrowser.primary.clientlets.html.HtmlContextMenu;
import org.lobobrowser.primary.clientlets.html.LocalParameterInfo;
import org.lobobrowser.primary.clientlets.html.UserAgentContextImpl;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.TargetType;
import org.lobobrowser.util.Urls;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HtmlRendererContextImpl
implements HtmlRendererContext {
    private static final Logger logger = Logger.getLogger(HtmlRendererContextImpl.class.getName());
    private static final Map<NavigatorFrame, WeakReference<HtmlRendererContextImpl>> weakAssociation = new WeakHashMap<NavigatorFrame, WeakReference<HtmlRendererContextImpl>>();
    private final NavigatorFrame clientletFrame;
    private final HtmlPanel htmlPanel;
    private volatile HtmlRendererContext assignedOpener;
    private UserAgentContext uaContext;

    private HtmlRendererContextImpl(NavigatorFrame clientletFrame) {
        this.clientletFrame = clientletFrame;
        this.htmlPanel = new HtmlPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HtmlRendererContextImpl getHtmlRendererContext(NavigatorFrame frame) {
        Map<NavigatorFrame, WeakReference<HtmlRendererContextImpl>> map = weakAssociation;
        synchronized (map) {
            HtmlRendererContextImpl hrc;
            WeakReference<HtmlRendererContextImpl> existingWR = weakAssociation.get(frame);
            if (existingWR != null && (hrc = (HtmlRendererContextImpl)existingWR.get()) != null) {
                return hrc;
            }
            hrc = new HtmlRendererContextImpl(frame);
            weakAssociation.put(frame, new WeakReference<HtmlRendererContextImpl>(hrc));
            return hrc;
        }
    }

    public Document getContentDocument() {
        DOMNodeImpl rootNode = this.htmlPanel.getRootNode();
        if (rootNode instanceof Document) {
            return (Document)((Object)rootNode);
        }
        return null;
    }

    public HtmlPanel getHtmlPanel() {
        return this.htmlPanel;
    }

    public void warn(String message, Throwable throwable) {
        logger.log(Level.WARNING, message, throwable);
    }

    public void error(String message, Throwable throwable) {
        logger.log(Level.SEVERE, message, throwable);
    }

    public void warn(String message) {
        logger.warning(message);
    }

    public void error(String message) {
        logger.log(Level.SEVERE, message);
    }

    @Override
    public void linkClicked(HTMLElement linkNode, URL url, String target) {
        this.navigateImpl(url, target, RequestType.CLICK, linkNode);
    }

    @Override
    public void navigate(URL href, String target) {
        this.navigateImpl(href, target, RequestType.PROGRAMMATIC, null);
    }

    private void navigateImpl(URL href, String target, RequestType requestType, Object linkObject) {
        TargetType targetType;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("navigateImpl(): href=" + href + ",target=" + target);
        }
        if (target != null) {
            Node frame;
            HtmlRendererContext topCtx = this.getTop();
            HTMLCollection frames = topCtx.getFrames();
            if (frames != null && (frame = frames.namedItem(target)) instanceof FrameNode) {
                BrowserFrame bframe = ((FrameNode)((Object)frame)).getBrowserFrame();
                if (bframe == null) {
                    throw new IllegalStateException("Frame node without a BrowserFrame instance: " + frame);
                }
                if (bframe.getHtmlRendererContext() != this) {
                    bframe.loadURL(href);
                    return;
                }
            }
            targetType = this.getTargetType(target);
        } else {
            targetType = TargetType.SELF;
        }
        if (requestType == RequestType.CLICK) {
            this.clientletFrame.linkClicked(href, targetType, linkObject);
        } else {
            this.clientletFrame.navigate(href, "GET", null, targetType, requestType);
        }
    }

    private TargetType getTargetType(String target) {
        if ("_blank".equalsIgnoreCase(target)) {
            return TargetType.BLANK;
        }
        if ("_parent".equalsIgnoreCase(target)) {
            return TargetType.PARENT;
        }
        if ("_top".equalsIgnoreCase(target)) {
            return TargetType.TOP;
        }
        return TargetType.SELF;
    }

    public HtmlRendererContext open(String url, String windowName, String windowFeatures, boolean replace) {
        try {
            URL urlObj = Urls.guessURL(url);
            return this.open(urlObj, windowName, windowFeatures, replace);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "open(): Unable to open URL [" + url + "].", err);
            return null;
        }
    }

    public int getLength() {
        HTMLCollection frames = this.getFrames();
        return frames == null ? 0 : frames.getLength();
    }

    public NavigatorFrame getClientletFrame() {
        return this.clientletFrame;
    }

    @Override
    public void submitForm(String method, URL url, String target, String enctype, FormInput[] formInputs) {
        TargetType targetType = this.getTargetType(target);
        LocalParameterInfo pinfo = new LocalParameterInfo(enctype, formInputs);
        this.clientletFrame.navigate(url, method, pinfo, targetType, RequestType.FORM);
    }

    @Override
    public BrowserFrame createBrowserFrame() {
        NavigatorFrame newFrame = this.clientletFrame.createFrame();
        return new BrowserFrameImpl(newFrame, this);
    }

    @Override
    public void alert(String message) {
        this.clientletFrame.alert(message);
    }

    @Override
    public void blur() {
        this.clientletFrame.windowToBack();
    }

    @Override
    public void close() {
        this.clientletFrame.closeWindow();
    }

    @Override
    public boolean confirm(String message) {
        return this.clientletFrame.confirm(message);
    }

    @Override
    public void focus() {
        this.clientletFrame.windowToFront();
    }

    @Override
    public HtmlRendererContext open(URL urlObj, String windowName, String windowFeatures, boolean replace) {
        Properties windowProperties = windowFeatures == null ? null : NavigatorWindowImpl.getPropertiesFromWindowFeatures(windowFeatures);
        try {
            NavigatorFrame newFrame = this.clientletFrame.open(urlObj, "GET", null, windowName, windowProperties);
            if (newFrame == null) {
                return null;
            }
            return HtmlRendererContextImpl.getHtmlRendererContext(newFrame);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "open(): Unable to open URL [" + urlObj + "].", err);
            return null;
        }
    }

    @Override
    public String prompt(String message, String inputDefault) {
        return this.clientletFrame.prompt(message, inputDefault);
    }

    @Override
    public void scroll(int x, int y) {
        this.htmlPanel.scroll(x, y);
    }

    @Override
    public void scrollBy(int xOffset, int yOffset) {
        this.htmlPanel.scrollBy(xOffset, yOffset);
    }

    @Override
    public boolean isClosed() {
        return this.clientletFrame.isWindowClosed();
    }

    @Override
    public String getDefaultStatus() {
        return this.clientletFrame.getDefaultStatus();
    }

    @Override
    public void setDefaultStatus(String value) {
        this.clientletFrame.setDefaultStatus(value);
    }

    @Override
    public HTMLCollection getFrames() {
        DOMNodeImpl rootNode = this.htmlPanel.getRootNode();
        if (rootNode instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)rootNode).getFrames();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.clientletFrame.getWindowId();
    }

    @Override
    public HtmlRendererContext getParent() {
        NavigatorFrame parentFrame = this.clientletFrame.getParentFrame();
        return parentFrame == null ? null : HtmlRendererContextImpl.getHtmlRendererContext(parentFrame);
    }

    @Override
    public HtmlRendererContext getOpener() {
        HtmlRendererContext opener = this.assignedOpener;
        if (opener != null) {
            return opener;
        }
        NavigatorFrame openerFrame = this.clientletFrame.getOpenerFrame();
        return openerFrame == null ? null : HtmlRendererContextImpl.getHtmlRendererContext(openerFrame);
    }

    @Override
    public void setOpener(HtmlRendererContext opener) {
        this.assignedOpener = opener;
    }

    @Override
    public String getStatus() {
        return this.clientletFrame.getStatus();
    }

    @Override
    public void setStatus(String message) {
        this.clientletFrame.setStatus(message);
    }

    @Override
    public void reload() {
        this.clientletFrame.reload();
    }

    @Override
    public HtmlRendererContext getTop() {
        NavigatorFrame parentFrame = this.clientletFrame.getTopFrame();
        return parentFrame == null ? null : HtmlRendererContextImpl.getHtmlRendererContext(parentFrame);
    }

    @Override
    public HtmlObject getHtmlObject(HTMLElement element) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAgentContext getUserAgentContext() {
        if (this.uaContext == null) {
            HtmlRendererContextImpl htmlRendererContextImpl = this;
            synchronized (htmlRendererContextImpl) {
                if (this.uaContext == null) {
                    this.uaContext = new UserAgentContextImpl(this.getClientletFrame());
                }
            }
        }
        return this.uaContext;
    }

    @Override
    public boolean isVisitedLink(HTMLAnchorElement link) {
        return false;
    }

    @Override
    public boolean onContextMenu(HTMLElement element, MouseEvent event) {
        HtmlContextMenu imageMenu = new HtmlContextMenu(element, this);
        if (element instanceof HTMLImageElementImpl) {
            JPopupMenu popupMenuImage = imageMenu.popupMenuImage();
            popupMenuImage.show(event.getComponent(), event.getX(), event.getY());
            return false;
        }
        if (element instanceof HTMLAnchorElementImpl) {
            JPopupMenu popupMenuImage = imageMenu.popupMenuLink();
            popupMenuImage.show(event.getComponent(), event.getX(), event.getY());
            return false;
        }
        if (element instanceof HTMLAbstractUIElement) {
            JPopupMenu popupMenuImage = imageMenu.popupMenuAbstractUI();
            popupMenuImage.show(event.getComponent(), event.getX(), event.getY());
            return false;
        }
        return true;
    }

    @Override
    public void onMouseOut(HTMLElement element, MouseEvent event) {
        if (element instanceof HTMLAnchorElementImpl) {
            this.clientletFrame.setStatus(null);
        }
    }

    @Override
    public boolean isImageLoadingEnabled() {
        return true;
    }

    @Override
    public void onMouseOver(HTMLElement element, MouseEvent event) {
        if (element instanceof HTMLAnchorElementImpl) {
            HTMLAnchorElementImpl linkElement = (HTMLAnchorElementImpl)element;
            this.clientletFrame.setStatus(linkElement.getAbsoluteHref());
        }
    }

    @Override
    public boolean onDoubleClick(HTMLElement element, MouseEvent event) {
        return true;
    }

    @Override
    public boolean onMouseClick(HTMLElement element, MouseEvent event) {
        return true;
    }

    @Override
    public void resizeBy(int byWidth, int byHeight) {
        this.clientletFrame.resizeWindowBy(byWidth, byHeight);
    }

    @Override
    public void resizeTo(int width, int height) {
        this.clientletFrame.resizeWindowTo(width, height);
    }

    @Override
    public void forward() {
        this.clientletFrame.forward();
    }

    @Override
    public void back() {
        this.clientletFrame.back();
    }

    @Override
    public String getCurrentURL() {
        NavigationEntry entry = this.clientletFrame.getCurrentNavigationEntry();
        return entry == null ? null : entry.getUrl().toExternalForm();
    }

    @Override
    public int getHistoryLength() {
        return this.clientletFrame.getHistoryLength();
    }

    @Override
    public String getNextURL() {
        NavigationEntry entry = this.clientletFrame.getNextNavigationEntry();
        return entry == null ? null : entry.getUrl().toExternalForm();
    }

    @Override
    public String getPreviousURL() {
        NavigationEntry entry = this.getClientletFrame().getPreviousNavigationEntry();
        return entry == null ? null : entry.getUrl().toExternalForm();
    }

    @Override
    public void goToHistoryURL(String url) {
        this.clientletFrame.navigateInHistory(url);
    }

    @Override
    public void moveInHistory(int offset) {
        this.clientletFrame.moveInHistory(offset);
    }

    @Override
    public void setCursor(Cursor cursorOpt) {
        Cursor cursor = cursorOpt;
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.htmlPanel.setCursor(cursor);
    }
}

