/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.lobobrowser.html.domimpl.HTMLAnchorElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.primary.clientlets.html.HtmlRendererContextImpl;
import org.lobobrowser.primary.ext.IconFactory;

public class HtmlContextMenu {
    private static final Logger logger = Logger.getLogger(HtmlContextMenu.class.getName());
    private HTMLElement element;
    private HtmlRendererContextImpl context;
    private final String SEARCH = "/toolbarButtonGraphics/general/Search16.gif";
    private final String COPY = "/toolbarButtonGraphics/general/Copy16.gif";
    private final String SAVE = "/toolbarButtonGraphics/general/Save16.gif";
    private final String BACK = "/toolbarButtonGraphics/navigation/Back16.gif";
    private final String RELOD = "/toolbarButtonGraphics/general/Refresh16.gif";
    private final String FORWARD = "/toolbarButtonGraphics/navigation/Forward16.gif";

    public HtmlContextMenu(HTMLElement element, HtmlRendererContextImpl context) {
        this.element = element;
        this.context = context;
    }

    public JPopupMenu popupMenuImage() {
        JPopupMenu popupMenu = new JPopupMenu();
        HTMLImageElementImpl img = (HTMLImageElementImpl)this.element;
        try {
            final URL srcUrl = img.getFullURL(img.getSrc());
            JMenuItem menuItem = new JMenuItem("View image");
            menuItem.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Search16.gif"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlContextMenu.this.context.navigate(srcUrl, null);
                }
            });
            popupMenu.add(menuItem);
            JMenuItem copyImageURL = new JMenuItem("Copy Image URL");
            copyImageURL.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Copy16.gif"));
            copyImageURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(srcUrl.toExternalForm()), null);
                }
            });
            popupMenu.add(copyImageURL);
            JMenuItem saveImage = new JMenuItem("Save Image");
            saveImage.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Save16.gif"));
            saveImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setAcceptAllFileFilterUsed(true);
                    int returnValue = fileChooser.showSaveDialog(HtmlContextMenu.this.context.getClientletFrame().getComponent());
                    if (returnValue == 0) {
                        int response;
                        File selectedFile = HtmlContextMenu.this.getSelectedFileWithExtension(fileChooser);
                        if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                            return;
                        }
                        BufferedImage image = null;
                        try {
                            int dot = srcUrl.toExternalForm().lastIndexOf(".");
                            String ext = srcUrl.toExternalForm().substring(dot + 1);
                            image = ImageIO.read(srcUrl);
                            ImageIO.write((RenderedImage)image, ext, selectedFile);
                        }
                        catch (Exception e1) {
                            logger.severe(e1.getMessage());
                        }
                    }
                }
            });
            popupMenu.add(saveImage);
        }
        catch (MalformedURLException e) {
            logger.severe(e.getMessage());
        }
        return popupMenu;
    }

    public JPopupMenu popupMenuLink() {
        JPopupMenu popupMenu = new JPopupMenu();
        final HTMLAnchorElementImpl link = (HTMLAnchorElementImpl)this.element;
        JMenuItem menuItem = new JMenuItem("Open link in new window");
        menuItem.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Search16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlContextMenu.this.context.open(link.getAbsoluteHref(), "window", null, false);
            }
        });
        popupMenu.add(menuItem);
        JMenuItem copyLinkURL = new JMenuItem("Copy link URL");
        copyLinkURL.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Copy16.gif"));
        copyLinkURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(link.getAbsoluteHref()), null);
            }
        });
        popupMenu.add(copyLinkURL);
        JMenuItem saveImage = new JMenuItem("Save destination");
        saveImage.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Save16.gif"));
        saveImage.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(2);
                fileChooser.setAcceptAllFileFilterUsed(true);
                int returnValue = fileChooser.showSaveDialog(HtmlContextMenu.this.context.getClientletFrame().getComponent());
                if (returnValue == 0) {
                    int response;
                    File selectedFile = HtmlContextMenu.this.getSelectedFileWithExtension(fileChooser);
                    if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                        return;
                    }
                    BufferedImage image = null;
                    try {
                        int dot = link.getAbsoluteHref().lastIndexOf(".");
                        String ext = link.getAbsoluteHref().substring(dot + 1);
                        image = ImageIO.read(new URL(link.getAbsoluteHref()));
                        ImageIO.write((RenderedImage)image, ext, selectedFile);
                    }
                    catch (Exception e1) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            baos.write(HtmlContextMenu.this.urlContent(link.getAbsoluteHref()).getBytes());
                            FileOutputStream ops = new FileOutputStream(selectedFile);
                            baos.writeTo(ops);
                            baos.flush();
                        }
                        catch (IOException e2) {
                            logger.severe(e1.getMessage());
                        }
                        finally {
                            try {
                                baos.close();
                            }
                            catch (IOException e2) {
                                logger.severe(e1.getMessage());
                            }
                        }
                    }
                }
            }
        });
        popupMenu.add(saveImage);
        return popupMenu;
    }

    public JPopupMenu popupMenuAbstractUI() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuBack = new JMenuItem("Back");
        menuBack.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/navigation/Back16.gif"));
        menuBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlContextMenu.this.context.back();
            }
        });
        if (this.context.getPreviousURL() != null && this.context.getPreviousURL().length() > 0) {
            menuBack.setEnabled(true);
        } else {
            menuBack.setEnabled(false);
        }
        popupMenu.add(menuBack);
        JMenuItem menuReload = new JMenuItem("Reload");
        menuReload.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/general/Refresh16.gif"));
        menuReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlContextMenu.this.context.reload();
            }
        });
        popupMenu.add(menuReload);
        JMenuItem menuForward = new JMenuItem("Forward");
        menuForward.setIcon(IconFactory.getInstance().getIcon("/toolbarButtonGraphics/navigation/Forward16.gif"));
        menuForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlContextMenu.this.context.forward();
            }
        });
        if (this.context.getNextURL() != null && this.context.getNextURL().length() > 0) {
            menuForward.setEnabled(true);
        } else {
            menuForward.setEnabled(false);
        }
        popupMenu.add(menuForward);
        return popupMenu;
    }

    private File getSelectedFileWithExtension(JFileChooser c) {
        File file = c.getSelectedFile();
        if (c.getFileFilter() instanceof FileNameExtensionFilter) {
            String[] exts = ((FileNameExtensionFilter)c.getFileFilter()).getExtensions();
            String nameLower = file.getName().toLowerCase();
            for (String ext : exts) {
                if (!nameLower.endsWith('.' + ext.toLowerCase())) continue;
                return file;
            }
            file = new File(file.toString() + exts[0]);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String urlContent(String webPage) {
        String result = "";
        StringBuffer sb = new StringBuffer();
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            int numCharsRead;
            URL url = new URL(webPage);
            URLConnection urlConnection = url.openConnection();
            is = urlConnection.getInputStream();
            isr = new InputStreamReader(is);
            char[] charArray = new char[1024];
            while ((numCharsRead = isr.read(charArray)) > 0) {
                sb.append(charArray, 0, numCharsRead);
            }
            result = sb.toString();
        }
        catch (MalformedURLException e) {
            logger.severe(e.getMessage());
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        finally {
            try {
                isr.close();
                is.close();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
        }
        return result;
    }
}

