/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.text.Document;
import org.lobobrowser.primary.ext.TextViewerWindow;
import org.lobobrowser.primary.gui.SearchDialog;
import org.lobobrowser.ua.NavigatorWindow;

public class TextViewerFindAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TextViewerFindAction.class.getName());
    private TextViewerWindow text;
    private NavigatorWindow window;
    private int pos = 0;

    public TextViewerFindAction(TextViewerWindow text, NavigatorWindow window) {
        this.text = text;
        this.window = window;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.searchWord();
    }

    private void searchWord() {
        Window awtWindow = this.window.getAwtWindow();
        if (!(awtWindow instanceof Frame)) {
            throw new IllegalStateException("Search dialog only supported when an AWT Frame is available.");
        }
        SearchDialog dialog = new SearchDialog((Frame)awtWindow, true, "");
        dialog.setTitle("Find");
        dialog.setLocationByPlatform(true);
        dialog.setResizable(false);
        dialog.setSize(new Dimension(200, 100));
        dialog.setVisible(true);
        String find = dialog.getSearchKeywords();
        this.text.getTextArea().requestFocusInWindow();
        if (find != null && find.length() > 0) {
            Document document = this.text.getTextArea().getDocument();
            int findLength = find.length();
            try {
                boolean found = false;
                if (this.pos + findLength > document.getLength()) {
                    this.pos = 0;
                }
                while (this.pos + findLength <= document.getLength()) {
                    String match = document.getText(this.pos, findLength);
                    if (match.equals(find)) {
                        found = true;
                        break;
                    }
                    ++this.pos;
                }
                if (found) {
                    Rectangle viewRect = this.text.getTextArea().modelToView(this.pos);
                    this.text.getTextArea().scrollRectToVisible(viewRect);
                    this.text.getTextArea().setCaretPosition(this.pos + findLength);
                    this.text.getTextArea().moveCaretPosition(this.pos);
                    this.pos += findLength;
                }
            }
            catch (Exception exp) {
                logger.severe(exp.getMessage());
            }
        }
    }
}

