/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URLEncoder;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.primary.gui.SearchDialog;
import org.lobobrowser.ua.NavigatorWindow;

public class SearchBookmarksAction
extends ActionPool {
    private static final long serialVersionUID = 1L;
    private NavigatorWindow window;

    public SearchBookmarksAction(ComponentSource componentSource, NavigatorWindow window) {
        super(componentSource, window);
        this.window = window;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.searchBookmarks();
    }

    private void searchBookmarks() {
        Window awtWindow = this.window.getAwtWindow();
        if (!(awtWindow instanceof Frame)) {
            throw new IllegalStateException("Search dialog only supported when an AWT Frame is available.");
        }
        SearchDialog dialog = new SearchDialog((Frame)awtWindow, true, "Keywords will be matched against URL, title, description and tags.");
        dialog.setTitle("Search Bookmarks");
        dialog.setLocationByPlatform(true);
        dialog.setResizable(false);
        dialog.setSize(new Dimension(200, 100));
        dialog.setVisible(true);
        String keywordsText = dialog.getSearchKeywords();
        if (keywordsText != null) {
            try {
                this.window.getTopFrame().navigate("about:bookmark-search?" + URLEncoder.encode(keywordsText, "UTF-8"));
            }
            catch (Exception thrown) {
                throw new IllegalStateException("not expected", thrown);
            }
        }
    }
}

