/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ClientletSelector;
import org.lobobrowser.main.ExtensionClassLoader;
import org.lobobrowser.main.PlatformStreamHandlerFactory;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.ua.ConnectionProcessor;
import org.lobobrowser.ua.NavigationEvent;
import org.lobobrowser.ua.NavigationListener;
import org.lobobrowser.ua.NavigationVetoException;
import org.lobobrowser.ua.NavigatorErrorListener;
import org.lobobrowser.ua.NavigatorExceptionEvent;
import org.lobobrowser.ua.NavigatorExtension;
import org.lobobrowser.ua.NavigatorExtensionContext;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.UserAgent;
import org.lobobrowser.util.EventDispatch2;

public class Extension
implements Comparable,
NavigatorExtensionContext {
    private static final String ATTRIBUTE_EXTENSION_CLASS = "extension.class";
    private static final String ATTRIBUTE_EXTENSION_PRIORITY = "extension.priority";
    private static final String EXTENSION_PROPERTIES_FILE = "lobo-extension.properties";
    private static final String PRIMARY_EXTENSION_FILE_NAME = "primary.jar";
    public static final int LOW_PRIORITY = 0;
    public static final int PRIMARY_EXTENSION_PRIORITY = 10;
    public static final int HIGH_PRIORITY = 9;
    public static final int NORMAL_PRIORITY = 5;
    private final int priority;
    private final File extRoot;
    private final JarFile jarFile;
    private final String extClassName;
    private final String extId;
    private final boolean isPrimary;
    private final boolean isLibrary;
    private final Collection<ClientletSelector> clientletSelectors;
    private final Collection<ConnectionProcessor> connectionProcessors;
    private final Collection<NavigationListener> navigationListeners;
    private final EventDispatch2 EVENT = new NavigatorErrorEventDispatch();
    private ClassLoader classLoader;
    private NavigatorExtension platformExtension;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension(File extRoot) throws IOException {
        FileInputStream propsInputStream;
        this.clientletSelectors = new LinkedList<ClientletSelector>();
        this.connectionProcessors = new ArrayList<ConnectionProcessor>();
        this.navigationListeners = new ArrayList<NavigationListener>();
        this.extRoot = extRoot;
        if (extRoot.isDirectory()) {
            this.isPrimary = false;
            this.jarFile = null;
            this.extId = extRoot.getName();
            File propsFile = new File(extRoot, EXTENSION_PROPERTIES_FILE);
            propsInputStream = propsFile.exists() ? new FileInputStream(propsFile) : null;
        } else {
            JarFile jarFile = new JarFile(extRoot);
            this.isPrimary = extRoot.getName().toLowerCase().equals(PRIMARY_EXTENSION_FILE_NAME);
            this.jarFile = jarFile;
            String name = extRoot.getName();
            int dotIdx = name.lastIndexOf(46);
            this.extId = dotIdx == -1 ? name : name.substring(0, dotIdx);
            JarEntry jarEntry = jarFile.getJarEntry(EXTENSION_PROPERTIES_FILE);
            propsInputStream = jarEntry == null ? null : jarFile.getInputStream(jarEntry);
        }
        boolean bl = this.isLibrary = propsInputStream == null;
        if (!this.isLibrary) {
            Properties mattribs = new Properties();
            try {
                mattribs.load(propsInputStream);
            }
            finally {
                ((InputStream)propsInputStream).close();
            }
            String extClassName = mattribs.getProperty(ATTRIBUTE_EXTENSION_CLASS);
            if (extClassName == null) {
                throw new IOException("Property extension.class missing in lobo-extension.properties, part of " + extRoot + ".");
            }
            this.extClassName = extClassName;
            String priorityText = mattribs.getProperty(ATTRIBUTE_EXTENSION_PRIORITY);
            if (priorityText != null) {
                int tp = Integer.parseInt(priorityText.trim());
                if (tp < 0) {
                    tp = 0;
                } else if (tp > 9) {
                    tp = 9;
                }
                this.priority = tp;
            } else {
                this.priority = 5;
            }
        } else {
            this.extClassName = null;
            this.priority = 10;
        }
    }

    public String getId() {
        return this.extId;
    }

    public URL getCodeSource() throws MalformedURLException {
        return this.extRoot.toURL();
    }

    public boolean isPrimaryExtension() {
        return this.isPrimary;
    }

    public boolean isLibraryOnly() {
        return this.isLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initClassLoader(ClassLoader parentClassLoader) throws MalformedURLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        URL url = this.extRoot.toURL();
        URL[] urls = new URL[]{url};
        ExtensionClassLoader classLoader = new ExtensionClassLoader(urls, parentClassLoader);
        String extClassName = this.extClassName;
        NavigatorExtension pe = null;
        if (extClassName != null) {
            Class<?> extClass = classLoader.loadClass(extClassName);
            pe = (NavigatorExtension)extClass.newInstance();
        }
        Extension extension = this;
        synchronized (extension) {
            this.classLoader = classLoader;
            this.platformExtension = pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Extension extension = this;
        synchronized (extension) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigatorExtension getNavigatorExtension() {
        Extension extension = this;
        synchronized (extension) {
            return this.platformExtension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initExtension() {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigatorExtension pe = this.platformExtension;
            if (pe != null) {
                pe.init(this);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initExtensionWindow(NavigatorWindow wcontext) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigatorExtension pe = this.platformExtension;
            if (pe != null) {
                pe.windowOpening(wcontext);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownExtensionWindow(NavigatorWindow wcontext) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigatorExtension pe = this.platformExtension;
            if (pe != null) {
                pe.windowClosing(wcontext);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientletSelector(ClientletSelector cs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.clientletSelectors.add(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Clientlet getClientlet(ClientletRequest request, ClientletResponse response) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            Extension extension = this;
            synchronized (extension) {
                for (ClientletSelector cs : this.clientletSelectors) {
                    Clientlet c = cs.select(request, response);
                    if (c == null) continue;
                    Clientlet clientlet = c;
                    return clientlet;
                }
            }
            extension = null;
            return extension;
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Clientlet getLastResortClientlet(ClientletRequest request, ClientletResponse response) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            Extension extension = this;
            synchronized (extension) {
                for (ClientletSelector cs : this.clientletSelectors) {
                    Clientlet c = cs.lastResortSelect(request, response);
                    if (c == null) continue;
                    Clientlet clientlet = c;
                    return clientlet;
                }
            }
            extension = null;
            return extension;
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    @Override
    public void addNavigatorErrorListener(NavigatorErrorListener listener) {
        this.EVENT.addListener(listener);
    }

    @Override
    public void removeNavigatorErrorListener(NavigatorErrorListener listener) {
        this.EVENT.removeListener(listener);
    }

    public boolean handleError(NavigatorExceptionEvent event) {
        return this.EVENT.fireEvent(event);
    }

    @Override
    public void addURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        PlatformStreamHandlerFactory.getInstance().addFactory(factory);
    }

    @Override
    public UserAgent getUserAgent() {
        return UserAgentImpl.getInstance();
    }

    public int compareTo(Object o) {
        Extension other = (Extension)o;
        int diff = other.priority - this.priority;
        if (diff != 0) {
            return diff;
        }
        return this.extRoot.compareTo(other.extRoot);
    }

    public int hashCode() {
        return this.priority | this.extRoot.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Extension)) {
            return false;
        }
        return ((Extension)other).extRoot.equals(this.extRoot);
    }

    public String toString() {
        return "ExtensionInfo[extRoot=" + this.extRoot + ",isLibrary=" + this.isLibrary + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionProcessor(ConnectionProcessor processor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.connectionProcessors.add(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(NavigationListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.navigationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientletSelector(ClientletSelector selector) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.clientletSelectors.remove(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionProcessor(ConnectionProcessor processor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.connectionProcessors.remove(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(NavigationListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        Extension extension = this;
        synchronized (extension) {
            this.navigationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchBeforeNavigate(NavigationEvent event) throws NavigationVetoException {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigationListener[] listeners;
            Collection<NavigationListener> nv = this.navigationListeners;
            Extension extension = this;
            synchronized (extension) {
                block10: {
                    if (!nv.isEmpty()) break block10;
                    return;
                }
                listeners = nv.toArray(NavigationListener.EMPTY_ARRAY);
            }
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].beforeNavigate(event);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchBeforeLocalNavigate(NavigationEvent event) throws NavigationVetoException {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigationListener[] listeners;
            Collection<NavigationListener> nv = this.navigationListeners;
            Extension extension = this;
            synchronized (extension) {
                block10: {
                    if (!nv.isEmpty()) break block10;
                    return;
                }
                listeners = nv.toArray(NavigationListener.EMPTY_ARRAY);
            }
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].beforeLocalNavigate(event);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchBeforeWindowOpen(NavigationEvent event) throws NavigationVetoException {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            NavigationListener[] listeners;
            Collection<NavigationListener> nv = this.navigationListeners;
            Extension extension = this;
            synchronized (extension) {
                block10: {
                    if (!nv.isEmpty()) break block10;
                    return;
                }
                listeners = nv.toArray(NavigationListener.EMPTY_ARRAY);
            }
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].beforeWindowOpen(event);
            }
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection dispatchPreConnection(URLConnection connection) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            ConnectionProcessor[] processors;
            Collection<ConnectionProcessor> cp = this.connectionProcessors;
            Extension extension = this;
            synchronized (extension) {
                block10: {
                    if (!cp.isEmpty()) break block10;
                    URLConnection uRLConnection = connection;
                    return uRLConnection;
                }
                processors = cp.toArray(ConnectionProcessor.EMPTY_ARRAY);
            }
            for (int i = 0; i < processors.length; ++i) {
                connection = processors[i].processPreConnection(connection);
            }
            URLConnection uRLConnection = connection;
            return uRLConnection;
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection dispatchPostConnection(URLConnection connection) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevClassLoader = currentThread.getContextClassLoader();
        ClassLoader loader = this.classLoader;
        if (loader != null) {
            currentThread.setContextClassLoader(loader);
        }
        try {
            ConnectionProcessor[] processors;
            Extension extension = this;
            synchronized (extension) {
                processors = this.connectionProcessors.toArray(ConnectionProcessor.EMPTY_ARRAY);
            }
            for (int i = 0; i < processors.length; ++i) {
                connection = processors[i].processPostConnection(connection);
            }
            URLConnection uRLConnection = connection;
            return uRLConnection;
        }
        finally {
            currentThread.setContextClassLoader(prevClassLoader);
        }
    }

    private static class NavigatorErrorEventDispatch
    extends EventDispatch2 {
        private NavigatorErrorEventDispatch() {
        }

        @Override
        protected void dispatchEvent(EventListener listener, EventObject event) {
            ((NavigatorErrorListener)listener).errorOcurred((NavigatorExceptionEvent)event);
        }
    }
}

