/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.renderstate.DisplayRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.HTMLTableElement;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Node;

public class TableCellRenderState
extends DisplayRenderState {
    private int alignXPercent = -1;
    private int alignYPercent = -1;
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;
    private HtmlInsets paddingInsets = INVALID_INSETS;

    public TableCellRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element, 5);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.alignXPercent = -1;
        this.alignYPercent = -1;
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
        this.paddingInsets = INVALID_INSETS;
    }

    @Override
    public int getAlignXPercent() {
        String textAlign;
        int axp = this.alignXPercent;
        if (axp != -1) {
            return axp;
        }
        AbstractCSS2Properties props = this.getCssProperties();
        if (props != null && (textAlign = props.getTextAlign()) != null && textAlign.length() != 0) {
            return super.getAlignXPercent();
        }
        String align = this.element.getAttribute("align");
        HTMLElementImpl element = this.element;
        HTMLElement rowElement = null;
        Node parent = element.getParentNode();
        if (parent instanceof HTMLElement) {
            rowElement = (HTMLElement)parent;
        }
        if (align == null || align.length() == 0) {
            if (rowElement != null) {
                align = rowElement.getAttribute("align");
                if (align != null && align.length() == 0) {
                    align = null;
                }
            } else {
                align = null;
            }
        }
        axp = align == null ? ("TH".equalsIgnoreCase(element.getNodeName()) ? 50 : 0) : ("center".equalsIgnoreCase(align) || "middle".equalsIgnoreCase(align) ? 50 : ("left".equalsIgnoreCase(align) ? 0 : ("right".equalsIgnoreCase(align) ? 100 : 0)));
        this.alignXPercent = axp;
        return axp;
    }

    @Override
    public int getAlignYPercent() {
        String textAlign;
        int ayp = this.alignYPercent;
        if (ayp != -1) {
            return ayp;
        }
        AbstractCSS2Properties props = this.getCssProperties();
        if (props != null && (textAlign = props.getVerticalAlign()) != null && textAlign.length() != 0) {
            return super.getAlignYPercent();
        }
        String valign = this.element.getAttribute("valign");
        HTMLElementImpl element = this.element;
        HTMLElement rowElement = null;
        Node parent = element.getParentNode();
        if (parent instanceof HTMLElement) {
            rowElement = (HTMLElement)parent;
        }
        if (valign == null || valign.length() == 0) {
            if (rowElement != null) {
                valign = rowElement.getAttribute("valign");
                if (valign != null && valign.length() == 0) {
                    valign = null;
                }
            } else {
                valign = null;
            }
        }
        ayp = valign == null ? 50 : ("top".equalsIgnoreCase(valign) ? 0 : ("middle".equalsIgnoreCase(valign) || "center".equalsIgnoreCase(valign) ? 50 : ("bottom".equalsIgnoreCase(valign) ? 100 : 50)));
        this.alignYPercent = ayp;
        return ayp;
    }

    @Override
    public BackgroundInfo getBackgroundInfo() {
        String background;
        BackgroundInfo binfo = this.backgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        HTMLTableCellElementImpl element = (HTMLTableCellElementImpl)this.element;
        HTMLTableRowElementImpl rowElement = null;
        Node parentNode = element.getParentNode();
        if (parentNode instanceof HTMLTableRowElementImpl) {
            rowElement = (HTMLTableRowElementImpl)parentNode;
        }
        if (binfo == null || binfo.backgroundColor == null) {
            String bgColor = element.getBgColor();
            if ((bgColor == null || "".equals(bgColor)) && rowElement != null) {
                bgColor = rowElement.getBgColor();
            }
            if (bgColor != null && !"".equals(bgColor)) {
                Color bgc = ColorFactory.getInstance().getColor(bgColor);
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundColor = bgc;
            }
        }
        if (!(binfo != null && binfo.backgroundImage != null || (background = element.getAttribute("background")) == null || "".equals(background))) {
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundImage = this.document.getFullURL(background);
        }
        this.backgroundInfo = binfo;
        return binfo;
    }

    private HTMLTableElement getTableElement() {
        Node ancestor;
        for (ancestor = this.element.getParentNode(); ancestor != null && !(ancestor instanceof HTMLTableElement); ancestor = ancestor.getParentNode()) {
        }
        return (HTMLTableElement)ancestor;
    }

    @Override
    public HtmlInsets getPaddingInsets() {
        HtmlInsets insets = this.paddingInsets;
        if (insets != INVALID_INSETS) {
            return insets;
        }
        insets = super.getPaddingInsets();
        if (insets == null) {
            HTMLTableElement tableElement = this.getTableElement();
            if (tableElement == null) {
                return null;
            }
            String cellPaddingText = tableElement.getAttribute("cellPadding");
            if (cellPaddingText != null && cellPaddingText.length() != 0) {
                int cellPadding;
                int cellPaddingType;
                if ((cellPaddingText = cellPaddingText.trim()).endsWith("%")) {
                    cellPaddingType = 3;
                    try {
                        cellPadding = Integer.parseInt(cellPaddingText.substring(0, cellPaddingText.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        cellPadding = 0;
                    }
                } else {
                    cellPaddingType = 1;
                    try {
                        cellPadding = Integer.parseInt(cellPaddingText);
                    }
                    catch (NumberFormatException nfe) {
                        cellPadding = 0;
                    }
                }
                insets = new HtmlInsets();
                insets.right = insets.bottom = cellPadding;
                insets.left = insets.bottom;
                insets.top = insets.bottom;
                insets.rightType = insets.bottomType = cellPaddingType;
                insets.leftType = insets.bottomType;
                insets.topType = insets.bottomType;
            }
        }
        this.paddingInsets = insets;
        return insets;
    }

    @Override
    public int getWhiteSpace() {
        String whiteSpaceTextTL;
        RenderState prs;
        HTMLElementImpl element;
        String whiteSpaceText;
        if (RenderThreadState.getState().overrideNoWrap) {
            return 2;
        }
        Integer ws = this.iWhiteSpace;
        if (ws != null) {
            return ws;
        }
        AbstractCSS2Properties props = this.getCssProperties();
        String string = whiteSpaceText = props == null ? null : props.getWhiteSpace();
        int wsValue = whiteSpaceText == null ? ((element = this.element) != null && element.getAttributeAsBoolean("nowrap") ? 2 : ((prs = this.prevRenderState) != null ? prs.getWhiteSpace() : 0)) : ("nowrap".equals(whiteSpaceTextTL = whiteSpaceText.toLowerCase()) ? 2 : ("pre".equals(whiteSpaceTextTL) ? 1 : 0));
        if (wsValue == 2) {
            String width;
            element = this.element;
            String string2 = width = props == null ? null : props.getWidth();
            if (width == null) {
                width = element.getAttribute("width");
                if (width != null && width.length() > 0 && !width.endsWith("%")) {
                    wsValue = 0;
                }
            } else if (!width.trim().endsWith("%")) {
                wsValue = 0;
            }
        }
        this.iWhiteSpace = new Integer(wsValue);
        return wsValue;
    }
}

