/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderstate;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.util.gui.ColorFactory;

public class BodyRenderState
extends StyleSheetRenderState {
    public BodyRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public BackgroundInfo getBackgroundInfo() {
        BackgroundInfo binfo = this.iBackgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        if (binfo == null || binfo.backgroundColor == null) {
            String bgcolor = this.element.getAttribute("bgcolor");
            String background = this.element.getAttribute("background");
            if (bgcolor != null && bgcolor.length() != 0) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundColor = ColorFactory.getInstance().getColor(bgcolor);
            }
            if (background != null && background.length() != 0) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundImage = this.document.getFullURL(background);
            }
        }
        this.iBackgroundInfo = binfo;
        return binfo;
    }

    @Override
    public Color getColor() {
        Color c = super.getColor();
        if (c != null) {
            return c;
        }
        String tcolor = this.element.getAttribute("text");
        if (tcolor == null) {
            tcolor = "black";
        }
        if (tcolor != null && tcolor.length() != 0) {
            c = ColorFactory.getInstance().getColor(tcolor);
        }
        return c;
    }

    @Override
    public HtmlInsets getMarginInsets() {
        HtmlInsets insets = this.marginInsets;
        if (insets != INVALID_INSETS) {
            return insets;
        }
        insets = super.getMarginInsets();
        if (insets == null) {
            HTMLElementImpl element = this.element;
            String leftMargin = element.getAttribute("leftmargin");
            String rightMargin = element.getAttribute("rightmargin");
            String bottomMargin = element.getAttribute("topmargin");
            String topMargin = element.getAttribute("topmargin");
            String marginWidth = element.getAttribute("marginWidth");
            String marginHeight = element.getAttribute("marginHeight");
            if (leftMargin == null) {
                leftMargin = marginWidth;
            }
            if (rightMargin == null) {
                rightMargin = marginWidth;
            }
            if (topMargin == null) {
                topMargin = marginHeight;
            }
            if (bottomMargin == null) {
                bottomMargin = marginHeight;
            }
            if (leftMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.left = HtmlValues.getOldSyntaxPixelSizeSimple(leftMargin, 0);
                insets.leftType = 1;
            }
            if (rightMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.right = HtmlValues.getOldSyntaxPixelSizeSimple(rightMargin, 0);
                insets.rightType = 1;
            }
            if (topMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.top = HtmlValues.getOldSyntaxPixelSizeSimple(topMargin, 0);
                insets.topType = 1;
            }
            if (bottomMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.bottom = HtmlValues.getOldSyntaxPixelSizeSimple(bottomMargin, 0);
                insets.bottomType = 1;
            }
        }
        this.marginInsets = insets;
        return insets;
    }
}

