/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.info.SizeInfo;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.VirtualCell;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.HtmlLength;

public class RTableCell
extends RBlock {
    private final HTMLTableCellElementImpl cellElement;
    private VirtualCell topLeftVirtualCell;
    private int colSpan = -1;
    private int rowSpan = -1;

    public RTableCell(HTMLTableCellElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer) {
        super(element, 0, pcontext, rcontext, frameContext, tableAsContainer);
        this.cellElement = element;
    }

    protected Dimension doCellLayout(int width, int height, boolean expandWidth, boolean expandHeight, boolean sizeOnly) {
        return this.doCellLayout(width, height, expandWidth, expandHeight, sizeOnly, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension doCellLayout(int width, int height, boolean expandWidth, boolean expandHeight, boolean sizeOnly, boolean useCache) {
        try {
            int cellWidth = 0;
            cellWidth = this.cellElement.getWidth() != null && this.cellElement.getWidth().length() > 0 ? new HtmlLength(this.cellElement.getWidth()).getLength(0) : width;
            int cellHeight = 0;
            cellHeight = this.cellElement.getHeight() != null && this.cellElement.getHeight().length() > 0 ? new HtmlLength(this.cellElement.getHeight()).getLength(0) : height;
            this.doLayout(cellWidth, cellHeight, expandWidth, expandHeight, null, 0, 0, sizeOnly, useCache);
            this.layout(cellWidth, cellHeight, expandWidth, expandHeight, null, sizeOnly);
            Dimension dimension = new Dimension(this.width, this.height);
            return dimension;
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    void clearLayoutCache() {
        this.cachedLayout.clear();
    }

    @Override
    protected Integer getDeclaredHeight(RenderState renderState, int availHeight) {
        return null;
    }

    @Override
    protected Integer getDeclaredWidth(RenderState renderState, int availWidth) {
        return null;
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void setTopLeftVirtualCell(VirtualCell vc) {
        this.topLeftVirtualCell = vc;
    }

    public VirtualCell getTopLeftVirtualCell() {
        return this.topLeftVirtualCell;
    }

    public int getVirtualColumn() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getColumn();
    }

    public int getVirtualRow() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getRow();
    }

    public int getColSpan() {
        int cs = this.colSpan;
        if (cs == -1) {
            cs = this.cellElement.getColSpan();
            if (cs < 1) {
                cs = 1;
            }
            this.colSpan = cs;
        }
        return cs;
    }

    public int getRowSpan() {
        int rs = this.rowSpan;
        if (rs == -1) {
            rs = this.cellElement.getRowSpan();
            if (rs < 1) {
                rs = 1;
            }
            this.rowSpan = rs;
        }
        return rs;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public String getHeightText() {
        return this.cellElement.getHeight();
    }

    public String getWidthText() {
        return this.cellElement.getWidth();
    }

    public void setCellBounds(SizeInfo[] colSizes, SizeInfo[] rowSizes, int hasBorder, int cellSpacingX, int cellSpacingY) {
        int height;
        int rowSpan;
        int width;
        int vcol = this.getVirtualColumn();
        int vrow = this.getVirtualRow();
        SizeInfo colSize = colSizes[vcol];
        SizeInfo rowSize = rowSizes[vrow];
        int x = colSize.offset;
        int y = rowSize.offset;
        int colSpan = this.getColSpan();
        if (colSpan > 1) {
            width = 0;
            for (int i = 0; i < colSpan; ++i) {
                int vc = vcol + i;
                width += colSizes[vc].actualSize;
                if (i + 1 >= colSpan) continue;
                width += cellSpacingX + hasBorder * 2;
            }
        } else {
            width = colSizes[vcol].actualSize;
        }
        if ((rowSpan = this.getRowSpan()) > 1) {
            height = 0;
            for (int i = 0; i < rowSpan; ++i) {
                int vr = vrow + i;
                height += rowSizes[vr].actualSize;
                if (i + 1 >= rowSpan) continue;
                height += cellSpacingY + hasBorder * 2;
            }
        } else {
            height = rowSizes[vrow].actualSize;
        }
        this.setBounds(x, y, width, height);
    }

    @Override
    protected boolean isMarginBoundary() {
        return true;
    }
}

