/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.CollectionUtilities;

public class RInlineBlock
extends BaseElementRenderable {
    private final RBlock child;

    public RInlineBlock(RenderableContainer container, HTMLElementImpl modelNode, UserAgentContext uacontext, HtmlRendererContext rendererContext, FrameContext frameContext) {
        super(container, modelNode, uacontext);
        RBlock child = new RBlock(modelNode, 0, this.userAgentContext, rendererContext, frameContext, this);
        child.setOriginalParent(this);
        child.setParent(this);
        this.child = child;
    }

    public void assignDimension() {
        this.width = this.child.getWidth();
        this.height = this.child.getHeight();
    }

    @Override
    public Iterator<? extends Renderable> getRenderables() {
        return CollectionUtilities.singletonIterator(this.child);
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return this.child.getLowestRenderableSpot(x, y);
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        return this.child.onDoubleClick(event, x, y);
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        return this.child.onMouseClick(event, x, y);
    }

    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        return this.child.onMouseDisarmed(event);
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        return this.child.onMousePressed(event, x, y);
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        return this.child.onMouseReleased(event, x, y);
    }

    @Override
    public boolean onKeyPressed(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyDown(KeyEvent event) {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        this.child.paint(g);
    }

    @Override
    public int getVAlign() {
        return 5;
    }

    @Override
    public void repaint(ModelNode modelNode) {
        this.child.repaint(modelNode);
    }

    @Override
    public Color getPaintedBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    protected void doLayout(int availWidth, int availHeight, boolean sizeOnly) {
        this.child.layout(availWidth, availHeight, false, false, null, sizeOnly);
        this.assignDimension();
    }

    @Override
    public Component addComponent(Component component) {
        this.container.addComponent(component);
        return super.addComponent(component);
    }
}

