/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.DOMElementImpl;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.gui.FrameSetPanel;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.LocalDocumentNotificationListener;
import org.lobobrowser.html.gui.NotificationTimerAction;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.gui.SelectionDispatch;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.w3c.HTMLFrameSetElement;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HtmlPanel
extends JComponent
implements FrameContext {
    private static final long serialVersionUID = 1L;
    private final EventDispatch2 selectionDispatch = new SelectionDispatch();
    private final Timer notificationTimer;
    private final DocumentNotificationListener notificationListener;
    private final Runnable notificationImmediateAction;
    private static final int NOTIF_TIMER_DELAY = 300;
    private volatile boolean isFrameSet = false;
    private volatile NodeRenderer nodeRenderer = null;
    private volatile DOMNodeImpl rootNode;
    private volatile int preferredWidth = -1;
    private volatile Insets defaultMarginInsets = new Insets(8, 8, 8, 8);
    private volatile int defaultOverflowX = 2;
    private volatile int defaultOverflowY = 1;
    protected volatile HtmlBlockPanel htmlBlockPanel;
    protected volatile FrameSetPanel frameSetPanel;
    private ArrayList<DocumentNotification> notifications = new ArrayList(1);

    public HtmlPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setOpaque(false);
        this.notificationTimer = new Timer(300, new NotificationTimerAction());
        this.notificationTimer.setRepeats(false);
        this.notificationListener = new LocalDocumentNotificationListener();
        this.notificationImmediateAction = new Runnable(){

            @Override
            public void run() {
                HtmlPanel.this.processNotifications();
            }
        };
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.setPreferredWidth(width);
        }
    }

    public void scrollTo(Rectangle bounds, boolean xIfNeeded, boolean yIfNeeded) {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.scrollTo(bounds, xIfNeeded, yIfNeeded);
        }
    }

    public void scrollTo(Node node) {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.scrollTo(node);
        }
    }

    public BoundableRenderable getBlockRenderable() {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        return htmlBlock == null ? null : htmlBlock.getRootRenderable();
    }

    public FrameSetPanel getFrameSetPanel() {
        int componentCount = this.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        Component c = this.getComponent(0);
        if (c instanceof FrameSetPanel) {
            return (FrameSetPanel)c;
        }
        return null;
    }

    private void setUpAsBlock(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        HtmlBlockPanel shp = this.createHtmlBlockPanel(ucontext, rcontext);
        shp.setPreferredWidth(this.preferredWidth);
        shp.setDefaultMarginInsets(this.defaultMarginInsets);
        shp.setDefaultOverflowX(this.defaultOverflowX);
        shp.setDefaultOverflowY(this.defaultOverflowY);
        this.htmlBlockPanel = shp;
        this.frameSetPanel = null;
        this.removeAll();
        this.add(shp);
        this.nodeRenderer = shp;
    }

    private void setUpFrameSet(DOMNodeImpl fsrn) {
        FrameSetPanel fsp;
        this.isFrameSet = true;
        this.htmlBlockPanel = null;
        this.frameSetPanel = fsp = this.createFrameSetPanel();
        this.nodeRenderer = fsp;
        this.removeAll();
        this.add(fsp);
        fsp.setRootNode(fsrn);
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        return new HtmlBlockPanel(Color.WHITE, true, ucontext, rcontext, this);
    }

    protected FrameSetPanel createFrameSetPanel() {
        return new FrameSetPanel();
    }

    public void scroll(final int x, final int y) {
        if (EventQueue.isDispatchThread()) {
            this.scrollImpl(x, y);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollImpl(x, y);
                }
            });
        }
    }

    public void scrollBy(final int x, final int y) {
        if (EventQueue.isDispatchThread()) {
            this.scrollByImpl(x, y);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollByImpl(x, y);
                }
            });
        }
    }

    private void scrollImpl(int x, int y) {
        this.scrollTo(new Rectangle(x, y, 16, 16), false, false);
    }

    private void scrollByImpl(int xOffset, int yOffset) {
        HtmlBlockPanel bp = this.htmlBlockPanel;
        if (bp != null) {
            bp.scrollBy(xOffset, yOffset);
        }
    }

    public void clearDocument() {
        if (EventQueue.isDispatchThread()) {
            this.clearDocumentImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.clearDocumentImpl();
                }
            });
        }
    }

    private void clearDocumentImpl() {
        NodeRenderer nr;
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        if ((nr = this.nodeRenderer) != null) {
            nr.setRootNode(null);
        }
        this.rootNode = null;
        this.htmlBlockPanel = null;
        this.nodeRenderer = null;
        this.isFrameSet = false;
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void setDocument(final Document node, final HtmlRendererContext rcontext) {
        if (EventQueue.isDispatchThread()) {
            this.setDocumentImpl(node, rcontext);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.setDocumentImpl(node, rcontext);
                }
            });
        }
    }

    public void scrollToElement(final String nameOrId) {
        if (EventQueue.isDispatchThread()) {
            this.scrollToElementImpl(nameOrId);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollToElementImpl(nameOrId);
                }
            });
        }
    }

    private void scrollToElementImpl(String nameOrId) {
        HTMLDocumentImpl doc;
        Element element;
        DOMNodeImpl node = this.rootNode;
        if (node instanceof HTMLDocumentImpl && (element = (doc = (HTMLDocumentImpl)node).getElementById(nameOrId)) != null) {
            this.scrollTo(element);
        }
    }

    private void setDocumentImpl(Document node, HtmlRendererContext rcontext) {
        NodeRenderer nr;
        boolean newIfs;
        if (!(node instanceof HTMLDocumentImpl)) {
            throw new IllegalArgumentException("Only nodes of type HTMLDocumentImpl are currently supported. Use DocumentBuilderImpl.");
        }
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        HTMLDocumentImpl nodeImpl = (HTMLDocumentImpl)node;
        nodeImpl.addDocumentNotificationListener(this.notificationListener);
        this.rootNode = nodeImpl;
        DOMNodeImpl fsrn = this.getFrameSetRootNode(nodeImpl);
        boolean bl = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
            } else {
                this.setUpAsBlock(rcontext.getUserAgentContext(), rcontext);
            }
        }
        if ((nr = this.nodeRenderer) != null) {
            if (newIfs) {
                nr.setRootNode(fsrn);
            } else {
                nr.setRootNode(nodeImpl);
            }
        } else {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHtml(String htmlSource, String uri, HtmlRendererContext rcontext) {
        try {
            DocumentBuilderImpl builder = new DocumentBuilderImpl(rcontext.getUserAgentContext(), rcontext);
            StringReader reader = new StringReader(htmlSource);
            try {
                InputSourceImpl is = new InputSourceImpl(reader, uri);
                Document document = builder.parse(is);
                this.setDocument(document, rcontext);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected condition.", ioe);
        }
        catch (SAXException se) {
            throw new IllegalStateException("Unexpected condition.", se);
        }
    }

    public DOMNodeImpl getRootNode() {
        return this.rootNode;
    }

    private boolean resetIfFrameSet() {
        boolean newIfs;
        DOMNodeImpl dOMNodeImpl = this.rootNode;
        DOMNodeImpl fsrn = this.getFrameSetRootNode(dOMNodeImpl);
        boolean bl = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
                NodeRenderer nr = this.nodeRenderer;
                nr.setRootNode(fsrn);
                this.validate();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private DOMNodeImpl getFrameSetRootNode(DOMNodeImpl node) {
        if (node instanceof Document) {
            DOMElementImpl element = (DOMElementImpl)((Document)((Object)node)).getDocumentElement();
            if (element != null && "HTML".equalsIgnoreCase(element.getTagName())) {
                return this.getFrameSet(element);
            }
            return this.getFrameSet(node);
        }
        return null;
    }

    private DOMNodeImpl getFrameSet(DOMNodeImpl node) {
        DOMNodeImpl[] children = node.getChildrenArray();
        if (children == null) {
            return null;
        }
        int length = children.length;
        DOMNodeImpl frameSet = null;
        for (int i = 0; i < length; ++i) {
            String tagName;
            DOMNodeImpl child = children[i];
            if (child instanceof Text || !(child instanceof DOMElementImpl) || "HEAD".equalsIgnoreCase(tagName = child.getNodeName()) || "NOFRAMES".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName) || "SCRIPT".equalsIgnoreCase(tagName) || "NOSCRIPT".equalsIgnoreCase(tagName)) continue;
            if ("FRAMESET".equalsIgnoreCase(tagName)) {
                frameSet = child;
                break;
            }
            if (!this.hasSomeHtml((DOMElementImpl)child)) continue;
            return null;
        }
        return frameSet;
    }

    private boolean hasSomeHtml(DOMElementImpl element) {
        String tagName = element.getTagName();
        if ("HEAD".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName)) {
            return false;
        }
        DOMNodeImpl[] children = element.getChildrenArray();
        if (children != null) {
            for (DOMNodeImpl child : children) {
                String textContent;
                if (!(child instanceof Text ? (textContent = ((Text)((Object)child)).getTextContent()) != null && !"".equals(textContent.trim()) : child instanceof DOMElementImpl && this.hasSomeHtml((DOMElementImpl)child))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void expandSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setSelectionEnd(rpoint);
            block.repaint();
            this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, block.isSelectionAvailable()));
        }
    }

    @Override
    public void resetSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setSelectionStart(rpoint);
            block.setSelectionEnd(rpoint);
            block.repaint();
        }
        this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, false));
    }

    public String getSelectionText() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return null;
        }
        return block.getSelectionText();
    }

    public Node getSelectionNode() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return null;
        }
        return block.getSelectionNode();
    }

    public boolean hasSelection() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return false;
        }
        return block.hasSelection();
    }

    public boolean copy() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            return block.copy();
        }
        return false;
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.addListener(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.removeListener(listener);
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultMarginInsets(insets);
        }
    }

    public void setDefaultOverflowX(int overflow) {
        this.defaultOverflowX = overflow;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultOverflowX(overflow);
        }
    }

    public void setDefaultOverflowY(int overflow) {
        this.defaultOverflowY = overflow;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultOverflowY(overflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(DocumentNotification notification) {
        ArrayList<DocumentNotification> notifs;
        ArrayList<DocumentNotification> arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(notification);
        }
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this.notificationImmediateAction);
        } else {
            this.notificationTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayedRelayout(DOMNodeImpl node) {
        ArrayList<DocumentNotification> notifs;
        ArrayList<DocumentNotification> arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(new DocumentNotification(2, node));
        }
        this.notificationTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotifications() {
        FrameSetPanel frameSetPanel;
        DocumentNotification[] notifsArray;
        ArrayList<DocumentNotification> notifs;
        ArrayList<DocumentNotification> arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            int size = notifs.size();
            if (size == 0) {
                return;
            }
            notifsArray = new DocumentNotification[size];
            notifsArray = notifs.toArray(notifsArray);
            notifs.clear();
        }
        int length = notifsArray.length;
        for (int i = 0; i < length; ++i) {
            DocumentNotification dn = notifsArray[i];
            if (!(dn.node instanceof HTMLFrameSetElement) || this.htmlBlockPanel == null || !this.resetIfFrameSet()) continue;
            return;
        }
        HtmlBlockPanel blockPanel = this.htmlBlockPanel;
        if (blockPanel != null) {
            blockPanel.processDocumentNotifications(notifsArray);
        }
        if ((frameSetPanel = this.frameSetPanel) != null) {
            frameSetPanel.processDocumentNotifications(notifsArray);
        }
    }
}

