/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.dombl.InputContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.w3c.HTMLTextAreaElement;
import org.lobobrowser.html.w3c.ValidityState;
import org.w3c.dom.NodeList;

public class HTMLTextAreaElementImpl
extends HTMLBaseInputElement
implements HTMLTextAreaElement {
    public HTMLTextAreaElementImpl(String name) {
        super(name);
    }

    public HTMLTextAreaElementImpl() {
        super("TEXTAREA");
    }

    @Override
    protected FormInput[] getFormInputs() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        return new FormInput[]{new FormInput(name, this.getValue())};
    }

    @Override
    public int getCols() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getCols();
    }

    @Override
    public int getRows() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getRows();
    }

    @Override
    public String getType() {
        return "textarea";
    }

    @Override
    public void setCols(int cols) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setCols(cols);
        }
    }

    @Override
    public void setRows(int rows) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setRows(rows);
        }
    }

    @Override
    public boolean getAutofocus() {
        String autofocus = this.getAttribute("autofocus");
        return "autofocus".equalsIgnoreCase(autofocus);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        this.setAttribute("autofocus", autofocus ? "autofocus" : null);
    }

    @Override
    public int getMaxLength() {
        try {
            return Integer.parseInt(this.getAttribute("maxlength"));
        }
        catch (Exception thrown) {
            this.warn("getMaxLength(): Unable to parse size attribute in " + this + ".", thrown);
            return 0;
        }
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.setAttribute("maxlength", String.valueOf(maxLength));
    }

    @Override
    public boolean getRequired() {
        String required = this.getAttribute("required");
        return "required".equalsIgnoreCase(required);
    }

    @Override
    public void setRequired(boolean required) {
        this.setAttribute("required", required ? "required" : null);
    }

    @Override
    public String getWrap() {
        return this.getAttribute("wrap");
    }

    @Override
    public void setWrap(String wrap) {
        this.setAttribute("wrap", wrap);
    }

    @Override
    public int getTextLength() {
        return this.getValue().length();
    }

    @Override
    public boolean getWillValidate() {
        return false;
    }

    @Override
    public ValidityState getValidity() {
        return null;
    }

    @Override
    public String getValidationMessage() {
        return null;
    }

    @Override
    public boolean checkValidity() {
        return false;
    }

    @Override
    public void setCustomValidity(String error) {
    }

    @Override
    public NodeList getLabels() {
        return null;
    }

    @Override
    public int getSelectionStart() {
        return 0;
    }

    @Override
    public void setSelectionStart(int selectionStart) {
    }

    @Override
    public int getSelectionEnd() {
        return 0;
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
    }

    @Override
    public void setSelectionRange(int start, int end) {
    }
}

