/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.File;
import java.util.logging.Level;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.dombl.InputContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.HTMLInputElement;
import org.lobobrowser.html.w3c.HTMLOptionElement;
import org.lobobrowser.html.w3c.ValidityState;
import org.w3c.dom.NodeList;

public class HTMLInputElementImpl
extends HTMLBaseInputElement
implements HTMLInputElement {
    private final String IMAGE = "image";
    private final String SUBMIT = "submit";
    private final String TEXT = "tetx";
    private final String PASSWORD = "password";
    private final String HIDDEN = "hidden";
    private final String RADIO = "radio";
    private final String CHECKBOX = "checkbox";
    private final String RESET = "reset";
    private final String FILE = "file";
    private boolean defaultChecked;

    public HTMLInputElementImpl(String name) {
        super(name);
    }

    @Override
    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultChecked = defaultChecked;
    }

    @Override
    public boolean getChecked() {
        InputContext ic = this.inputContext;
        if (ic == null) {
            return this.getAttributeAsBoolean("checked");
        }
        return ic.getChecked();
    }

    @Override
    public void setChecked(boolean checked) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setChecked(checked);
        }
    }

    @Override
    public int getMaxLength() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getMaxLength();
    }

    @Override
    public void setMaxLength(int maxLength) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setMaxLength(maxLength);
        }
    }

    @Override
    public int getSize() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getControlSize();
    }

    @Override
    public void setSize(int size) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setControlSize(size);
        }
    }

    @Override
    public String getType() {
        String type = this.getAttribute("type");
        return type == null ? null : type.toLowerCase();
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public String getUseMap() {
        return this.getAttribute("useMap");
    }

    @Override
    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    @Override
    public void click() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.click();
        }
    }

    public boolean isSubmittableWithEnterKey() {
        String type = this.getType();
        return type == null || "".equals(type) || "tetx".equals(type) || "password".equals(type);
    }

    public boolean isSubmittableWithPress() {
        String type = this.getType();
        return "submit".equals(type) || "image".equals(type);
    }

    public boolean isSubmitInput() {
        String type = this.getType();
        return "submit".equals(type);
    }

    public boolean isImageInput() {
        String type = this.getType();
        return "image".equals(type);
    }

    public boolean isResetInput() {
        String type = this.getType();
        return "reset".equals(type);
    }

    @Override
    void resetInput() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.resetInput();
        }
    }

    @Override
    protected FormInput[] getFormInputs() {
        String type = this.getType();
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (type == null) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("tetx".equals(type) || "password".equals(type) || "hidden".equals(type) || "".equals(type)) {
            return new FormInput[]{new FormInput(name, this.getValue())};
        }
        if ("submit".equals(type)) {
            return null;
        }
        if ("radio".equals(type) || "checkbox".equals(type)) {
            if (this.getChecked()) {
                String value = this.getValue();
                if (value == null || value.length() == 0) {
                    value = "on";
                }
                return new FormInput[]{new FormInput(name, value)};
            }
            return null;
        }
        if ("image".equals(type)) {
            return null;
        }
        if ("file".equals(type)) {
            File[] files = this.getFileValue();
            if (files == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("getFormInputs(): File input named " + name + " has null file.");
                }
                return null;
            }
            return new FormInput[]{new FormInput(name, files)};
        }
        return null;
    }

    @Override
    public boolean getAutocomplete() {
        String autocomplete = this.getAttribute("autocomplete");
        return "muted".equalsIgnoreCase(autocomplete);
    }

    @Override
    public void setAutocomplete(boolean autocomplete) {
        this.setAttribute("autocomplete", autocomplete ? "autocomplete" : null);
    }

    @Override
    public boolean getAutofocus() {
        String focus = this.getAttribute("autofocus");
        return "autofocus".equalsIgnoreCase(focus);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        this.setAttribute("autofocus", autofocus ? "autofocus" : null);
    }

    @Override
    public File[] getFiles() {
        InputContext ic = this.inputContext;
        return ic.getFileValue();
    }

    @Override
    public String getFormAction() {
        return this.getAttribute("formaction");
    }

    @Override
    public void setFormAction(String formAction) {
        this.setAttribute("formaction", formAction);
    }

    @Override
    public String getFormEnctype() {
        return this.getAttribute("formenctype");
    }

    @Override
    public void setFormEnctype(String formEnctype) {
        this.setAttribute("formenctype", formEnctype);
    }

    @Override
    public String getFormMethod() {
        return this.getAttribute("formmethod");
    }

    @Override
    public void setFormMethod(String formMethod) {
        this.setAttribute("formmethod", formMethod);
    }

    @Override
    public boolean getFormNoValidate() {
        String formNoValidate = this.getAttribute("formnovalidate");
        return "formnovalidate".equalsIgnoreCase(formNoValidate);
    }

    @Override
    public void setFormNoValidate(boolean formNoValidate) {
        this.setAttribute("formnovalidate", formNoValidate ? "formnovalidate" : null);
    }

    @Override
    public String getFormTarget() {
        return this.getAttribute("formtarget");
    }

    @Override
    public void setFormTarget(String formTarget) {
        this.setAttribute("formtarget", formTarget);
    }

    @Override
    public String getHeight() {
        return this.getAttribute("height");
    }

    @Override
    public void setHeight(String height) {
        this.setAttribute("height", height);
    }

    @Override
    public boolean getIndeterminate() {
        return false;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public HTMLElement getList() {
        return null;
    }

    @Override
    public String getMax() {
        return this.getAttribute("max");
    }

    @Override
    public void setMax(String max) {
        this.setAttribute("max", max);
    }

    @Override
    public String getMin() {
        return this.getAttribute("min");
    }

    @Override
    public void setMin(String min) {
        this.setAttribute("min", min);
    }

    @Override
    public boolean getMultiple() {
        String multiple = this.getAttribute("multiple");
        return "multiple".equalsIgnoreCase(multiple);
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple ? "multiple" : null);
    }

    @Override
    public String getPattern() {
        return this.getAttribute("pattern");
    }

    @Override
    public void setPattern(String pattern) {
        this.setAttribute("pattern", pattern);
    }

    @Override
    public boolean getRequired() {
        String required = this.getAttribute("required");
        return "required".equalsIgnoreCase(required);
    }

    @Override
    public void setRequired(boolean required) {
        this.setAttribute("required", required ? "required" : null);
    }

    @Override
    public String getStep() {
        return this.getAttribute("step");
    }

    @Override
    public void setStep(String step) {
        this.setAttribute("step", step);
    }

    @Override
    public long getValueAsDate() {
        return 0L;
    }

    @Override
    public void setValueAsDate(long valueAsDate) {
    }

    @Override
    public float getValueAsNumber() {
        return 0.0f;
    }

    @Override
    public void setValueAsNumber(float valueAsNumber) {
    }

    @Override
    public HTMLOptionElement getSelectedOption() {
        return null;
    }

    @Override
    public String getWidth() {
        if (this.getType().equalsIgnoreCase("image")) {
            return this.getAttribute("width");
        }
        return null;
    }

    @Override
    public void setWidth(String width) {
        if (this.getType().equalsIgnoreCase("image")) {
            this.setAttribute("width", width);
        }
    }

    @Override
    public void stepUp() {
    }

    @Override
    public void stepUp(int n) {
    }

    @Override
    public void stepDown() {
    }

    @Override
    public void stepDown(int n) {
    }

    @Override
    public boolean getWillValidate() {
        return false;
    }

    @Override
    public ValidityState getValidity() {
        return null;
    }

    @Override
    public String getValidationMessage() {
        return null;
    }

    @Override
    public boolean checkValidity() {
        return false;
    }

    @Override
    public void setCustomValidity(String error) {
    }

    @Override
    public NodeList getLabels() {
        return null;
    }

    @Override
    public int getSelectionStart() {
        return 0;
    }

    @Override
    public void setSelectionStart(int selectionStart) {
    }

    @Override
    public int getSelectionEnd() {
        return 0;
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
    }

    @Override
    public void setSelectionRange(int start, int end) {
    }
}

