/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.dombl.DescendentHTMLCollection;
import org.lobobrowser.html.dombl.NodeVisitor;
import org.lobobrowser.html.dombl.StopVisitorException;
import org.lobobrowser.html.domfilter.InputFilter;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.html.w3c.HTMLFormElement;
import org.mozilla.javascript.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLFormElementImpl
extends HTMLAbstractUIElement
implements HTMLFormElement {
    private HTMLCollection elements;
    private Function onsubmit;

    public HTMLFormElementImpl(String name) {
        super(name);
    }

    public HTMLFormElementImpl() {
        super("FORM");
    }

    @Override
    public Object namedItem(final String name) {
        try {
            this.visit(new NodeVisitor(){

                @Override
                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node) && name.equals(((Element)node).getAttribute("name"))) {
                        throw new StopVisitorException(node);
                    }
                }
            });
        }
        catch (StopVisitorException sve) {
            return sve.getTag();
        }
        return null;
    }

    @Override
    public Object item(final int index) {
        try {
            this.visit(new NodeVisitor(){
                private int current = 0;

                @Override
                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node)) {
                        if (this.current == index) {
                            throw new StopVisitorException(node);
                        }
                        ++this.current;
                    }
                }
            });
        }
        catch (StopVisitorException sve) {
            return sve.getTag();
        }
        return null;
    }

    @Override
    public HTMLCollection getElements() {
        HTMLCollection elements = this.elements;
        if (elements == null) {
            this.elements = elements = new DescendentHTMLCollection(this, new InputFilter(), this.getTreeLock(), false);
        }
        return elements;
    }

    @Override
    public int getLength() {
        return this.getElements().getLength();
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getAcceptCharset() {
        return this.getAttribute("acceptcharset");
    }

    @Override
    public void setAcceptCharset(String acceptCharset) {
        this.setAttribute("acceptcharset", acceptCharset);
    }

    @Override
    public String getAction() {
        return this.getAttribute("action");
    }

    @Override
    public void setAction(String action) {
        this.setAttribute("action", action);
    }

    @Override
    public String getEnctype() {
        return this.getAttribute("enctype");
    }

    @Override
    public void setEnctype(String enctype) {
        this.setAttribute("enctype", enctype);
    }

    @Override
    public String getMethod() {
        String method = this.getAttribute("method");
        if (method == null) {
            method = "GET";
        }
        return method;
    }

    @Override
    public void setMethod(String method) {
        this.setAttribute("method", method);
    }

    @Override
    public String getTarget() {
        return this.getAttribute("target");
    }

    @Override
    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    @Override
    public void submit() {
        this.submit(null);
    }

    @Override
    public void setOnsubmit(Function value) {
        this.onsubmit = value;
    }

    @Override
    public Function getOnsubmit() {
        return this.getEventFunction(this.onsubmit, "onsubmit");
    }

    public final void submit(FormInput[] extraFormInputs) {
        Function onsubmit = this.getOnsubmit();
        if (onsubmit != null && !Executor.executeFunction(this, onsubmit, null)) {
            return;
        }
        HtmlRendererContext context = this.getHtmlRendererContext();
        if (context != null) {
            final ArrayList<FormInput> formInputs = new ArrayList<FormInput>();
            if (extraFormInputs != null) {
                for (int i = 0; i < extraFormInputs.length; ++i) {
                    formInputs.add(extraFormInputs[i]);
                }
            }
            this.visit(new NodeVisitor(){

                @Override
                public void visit(Node node) {
                    FormInput[] fis;
                    if (node instanceof HTMLElementImpl && (fis = ((HTMLElementImpl)node).getFormInputs()) != null) {
                        for (int i = 0; i < fis.length; ++i) {
                            FormInput fi = fis[i];
                            if (fi.getName() == null) {
                                throw new IllegalStateException("Form input does not have a name: " + node);
                            }
                            formInputs.add(fi);
                        }
                    }
                }
            });
            FormInput[] fia = formInputs.toArray(FormInput.EMPTY_ARRAY);
            String href = this.getAction();
            if (href == null) {
                href = this.getBaseURI();
            }
            try {
                URL url = this.getFullURL(href);
                context.submitForm(this.getMethod(), url, this.getTarget(), this.getEnctype(), fia);
            }
            catch (MalformedURLException mfu) {
                this.warn("submit()", mfu);
            }
        }
    }

    @Override
    public void reset() {
        this.visit(new NodeVisitor(){

            @Override
            public void visit(Node node) {
                if (node instanceof HTMLBaseInputElement) {
                    ((HTMLBaseInputElement)node).resetInput();
                }
            }
        });
    }

    public static boolean isInput(Node node) {
        String name = node.getNodeName().toLowerCase();
        return name.equals("input") || name.equals("textarea") || name.equals("select");
    }

    @Override
    public boolean getAutocomplete() {
        String autocomplete = this.getAttribute("autocomplete");
        return "autocomplete".equalsIgnoreCase(autocomplete);
    }

    @Override
    public void setAutocomplete(boolean autocomplete) {
        this.setAttribute("autocomplete", autocomplete ? "autocomplete" : null);
    }

    @Override
    public boolean getNoValidate() {
        String noValidate = this.getAttribute("novalidate");
        return "novalidate".equalsIgnoreCase(noValidate);
    }

    @Override
    public void setNoValidate(boolean noValidate) {
        this.setAttribute("novalidate", noValidate ? "novalidate" : null);
    }

    @Override
    public boolean checkValidity() {
        return false;
    }

    @Override
    public void dispatchFormInput() {
    }

    @Override
    public void dispatchFormChange() {
    }
}

