/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlCommandMapping;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.CSSStyleSheetList;
import org.lobobrowser.html.dombl.DescendentHTMLCollection;
import org.lobobrowser.html.dombl.DocumentNotificationListener;
import org.lobobrowser.html.dombl.ElementFactory;
import org.lobobrowser.html.dombl.ImageEvent;
import org.lobobrowser.html.dombl.ImageInfo;
import org.lobobrowser.html.dombl.ImageListener;
import org.lobobrowser.html.dombl.LocalErrorHandler;
import org.lobobrowser.html.dombl.NodeVisitor;
import org.lobobrowser.html.dombl.QuerySelectorImpl;
import org.lobobrowser.html.domfilter.AnchorFilter;
import org.lobobrowser.html.domfilter.AppletFilter;
import org.lobobrowser.html.domfilter.ClassNameFilter;
import org.lobobrowser.html.domfilter.CommandFilter;
import org.lobobrowser.html.domfilter.ElementAttributeFilter;
import org.lobobrowser.html.domfilter.ElementFilter;
import org.lobobrowser.html.domfilter.ElementNameFilter;
import org.lobobrowser.html.domfilter.EmbedFilter;
import org.lobobrowser.html.domfilter.FormFilter;
import org.lobobrowser.html.domfilter.FrameFilter;
import org.lobobrowser.html.domfilter.ImageFilter;
import org.lobobrowser.html.domfilter.LinkFilter;
import org.lobobrowser.html.domfilter.PluginsFilter;
import org.lobobrowser.html.domfilter.ScriptFilter;
import org.lobobrowser.html.domfilter.TagNameFilter;
import org.lobobrowser.html.domimpl.DOMAttrImpl;
import org.lobobrowser.html.domimpl.DOMCDataSectionImpl;
import org.lobobrowser.html.domimpl.DOMCommentImpl;
import org.lobobrowser.html.domimpl.DOMConfigurationImpl;
import org.lobobrowser.html.domimpl.DOMFragmentImpl;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.DOMTextImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLProcessingInstruction;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.Location;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.jsimpl.CustomEventImpl;
import org.lobobrowser.html.jsimpl.EventImpl;
import org.lobobrowser.html.jsimpl.KeyboardEventImpl;
import org.lobobrowser.html.jsimpl.MouseEventImpl;
import org.lobobrowser.html.jsimpl.MutationEventImpl;
import org.lobobrowser.html.jsimpl.MutationNameEventImpl;
import org.lobobrowser.html.jsimpl.TextEventImpl;
import org.lobobrowser.html.jsimpl.UIEventImpl;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.renderstate.StyleSheetRenderState;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.html.w3c.HTMLDocument;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.HTMLHeadElement;
import org.lobobrowser.html.w3c.events.DocumentEvent;
import org.lobobrowser.html.w3c.events.Event;
import org.lobobrowser.http.SSLCertificate;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.WeakValueHashMap;
import org.lobobrowser.util.io.EmptyReader;
import org.mozilla.javascript.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;
import org.xml.sax.SAXException;

public class HTMLDocumentImpl
extends DOMNodeImpl
implements HTMLDocument,
DocumentView,
DocumentEvent {
    private static final Logger logger = Logger.getLogger(HTMLDocumentImpl.class.getName());
    private final ElementFactory factory;
    private final HtmlRendererContext rcontext;
    private final UserAgentContext ucontext;
    private final Window window;
    private final Map<String, Element> elementsById = new WeakValueHashMap();
    private final Map<String, Element> elementsByName = new HashMap<String, Element>(0);
    private final Collection styleSheets = new CSSStyleSheetList();
    private final Map<String, ImageInfo> imageInfos = new HashMap<String, ImageInfo>(4);
    private final ArrayList<DocumentNotificationListener> documentNotificationListeners = new ArrayList(1);
    private final ImageEvent BLANK_IMAGE_EVENT = new ImageEvent(this, null);
    private URL documentURL;
    private WritableLineReader reader;
    private DocumentType doctype;
    private HTMLElement body;
    private HTMLCollection images;
    private HTMLCollection applets;
    private HTMLCollection links;
    private HTMLCollection forms;
    private HTMLCollection anchors;
    private HTMLCollection frames;
    private HTMLCollection embeds;
    private HTMLCollection scripts;
    private HTMLCollection plugins;
    private HTMLCollection commands;
    private StyleSheetAggregator styleSheetAggregator = null;
    private DOMConfiguration domConfig;
    private DOMImplementation domImplementation;
    private Function onloadHandler;
    private Set<?> locales;
    private volatile String baseURI;
    private String defaultTarget;
    private String title;
    private String documentURI;
    private String referrer;
    private String domain;
    private String inputEncoding;
    private String xmlEncoding;
    private String xmlVersion = null;
    private boolean xmlStandalone;
    private boolean strictErrorChecking = true;
    private Function onclick;
    private Function ondblclick;
    private Function onkeydown;
    private Function onkeypress;
    private Function onkeyup;
    private Function onmousedown;
    private Function onmouseup;
    private Function onunload;
    private Function onmouseout;
    private Function onmouseover;

    public HTMLDocumentImpl(HtmlRendererContext rcontext) {
        this(rcontext.getUserAgentContext(), rcontext, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext ucontext) {
        this(ucontext, null, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext ucontext, HtmlRendererContext rcontext, WritableLineReader reader, String documentURI) {
        Window window;
        this.factory = ElementFactory.getInstance();
        this.rcontext = rcontext;
        this.ucontext = ucontext;
        this.reader = reader;
        this.documentURI = documentURI;
        try {
            URL docURL = new URL(documentURI);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new SocketPermission(docURL.getHost(), "connect"));
            }
            this.documentURL = docURL;
            this.domain = docURL.getHost();
        }
        catch (MalformedURLException mfu) {
            logger.warning("HTMLDocumentImpl(): Document URI [" + documentURI + "] is malformed.");
        }
        this.document = this;
        if (rcontext != null) {
            window = Window.getWindow(rcontext);
            window.setDocument(this);
            this.setUserData("cobra.js.scope", window.getWindowScope(), null);
        } else {
            window = null;
        }
        this.window = window;
    }

    @Override
    public String getCookie() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return HTMLDocumentImpl.this.ucontext.getCookie(HTMLDocumentImpl.this.documentURL);
                }
            });
        }
        return this.ucontext.getCookie(this.documentURL);
    }

    @Override
    public void setCookie(final String cookie) throws DOMException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    HTMLDocumentImpl.this.ucontext.setCookie(HTMLDocumentImpl.this.documentURL, cookie);
                    return null;
                }
            });
        } else {
            this.ucontext.setCookie(this.documentURL, cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.reader != null) {
                if (this.reader instanceof LocalWritableLineReader) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.reader = null;
                } else {
                    return;
                }
            }
            this.removeAllChildrenImpl();
            this.reader = new LocalWritableLineReader(new EmptyReader());
        }
    }

    public void load() throws IOException, SAXException, UnsupportedEncodingException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean closeReader) throws IOException, SAXException, UnsupportedEncodingException {
        WritableLineReader reader;
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAllChildrenImpl();
            this.setTitle(null);
            this.setBaseURI(null);
            this.setDefaultTarget(null);
            this.styleSheets.clear();
            this.styleSheetAggregator = null;
            reader = this.reader;
        }
        if (reader != null) {
            try {
                String systemId;
                LocalErrorHandler errorHandler = new LocalErrorHandler();
                String publicId = systemId = this.documentURI;
                HtmlParser parser = new HtmlParser(this.ucontext, this, errorHandler, publicId, systemId);
                parser.parse(reader);
            }
            finally {
                if (closeReader) {
                    try {
                        reader.close();
                    }
                    catch (Exception err) {
                        logger.log(Level.WARNING, "load(): Unable to close stream", err);
                    }
                    object = this.getTreeLock();
                    synchronized (object) {
                        this.reader = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.reader instanceof LocalWritableLineReader) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String text) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(text);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeln(String text) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(text + "\r\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void openBufferChanged(String text) {
        String systemId;
        LocalErrorHandler errorHandler = new LocalErrorHandler();
        String publicId = systemId = this.documentURI;
        HtmlParser parser = new HtmlParser(this.ucontext, this, errorHandler, publicId, systemId);
        StringReader strReader = new StringReader(text);
        try {
            parser.parse(strReader);
        }
        catch (Exception err) {
            this.warn("Unable to parse written HTML text. BaseURI=[" + this.getBaseURI() + "].", err);
        }
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        return this.getNodeList(new ElementNameFilter(elementName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getDocumentElement() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                for (Object node : nl) {
                    if (!(node instanceof Element)) continue;
                    return (Element)node;
                }
            }
            return null;
        }
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return this.factory.createElement(this, tagName);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        DOMFragmentImpl node = new DOMFragmentImpl();
        node.setOwnerDocument(this);
        return node;
    }

    @Override
    public Text createTextNode(String data) {
        DOMTextImpl node = new DOMTextImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    @Override
    public Comment createComment(String data) {
        DOMCommentImpl node = new DOMCommentImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        DOMCDataSectionImpl node = new DOMCDataSectionImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        HTMLProcessingInstruction node = new HTMLProcessingInstruction(target, data);
        node.setOwnerDocument(this);
        return node;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return new DOMAttrImpl(name);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        if ("*".equals(tagname)) {
            return this.getNodeList(new ElementFilter());
        }
        return this.getNodeList(new TagNameFilter(tagname));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "Not implemented");
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    @Override
    public Event createEvent(String eventType) throws DOMException {
        if (eventType.equals("Event")) {
            return new EventImpl();
        }
        if (eventType.equals("UIEvent")) {
            return new UIEventImpl();
        }
        if (eventType.equals("MouseEvent")) {
            return new MouseEventImpl();
        }
        if (eventType.equals("MutationEvent")) {
            return new MutationEventImpl();
        }
        if (eventType.equals("MutationNameEvent")) {
            return new MutationNameEventImpl();
        }
        if (eventType.equals("TextEvent")) {
            return new TextEventImpl();
        }
        if (eventType.equals("KeyboardEvent")) {
            return new KeyboardEventImpl();
        }
        if (eventType.equals("CustomEvent")) {
            return new CustomEventImpl();
        }
        return new EventImpl();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new DOMException(9, "HTML document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getElementById(String elementId) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = this.elementsById.get(elementId);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element namedItem(String name) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = this.elementsByName.get(name);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamedItem(String name, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.put(name, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamedItem(String name) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.remove(name);
        }
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        if (source instanceof DOMNodeImpl) {
            DOMNodeImpl node = (DOMNodeImpl)source;
            node.setOwnerDocument(this, true);
            return node;
        }
        throw new DOMException(9, "Invalid Node implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOMConfiguration getDomConfig() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domConfig == null) {
                this.domConfig = new DOMConfigurationImpl();
            }
            return this.domConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeDocument() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.visitImpl(new NodeVisitor(){

                @Override
                public void visit(Node node) {
                    node.normalize();
                }
            });
        }
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "No renaming");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOMImplementation getImplementation() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.ucontext);
            }
            return this.domImplementation;
        }
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(13, "Cannot set node value of document");
    }

    @Override
    public final HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    @Override
    public UserAgentContext getUserAgentContext() {
        return this.ucontext;
    }

    @Override
    public final URL getFullURL(String uri) {
        try {
            String baseURI = this.getBaseURI();
            URL documentURL = baseURI == null ? null : new URL(baseURI);
            return Urls.createURL(documentURL, uri);
        }
        catch (MalformedURLException mfu) {
            try {
                return new URL(uri);
            }
            catch (MalformedURLException mfu2) {
                logger.log(Level.WARNING, "Unable to create URL for URI=[" + uri + "], with base=[" + this.getBaseURI() + "].", mfu);
                return null;
            }
        }
        catch (UnsupportedEncodingException mfu) {
            try {
                return new URL(uri);
            }
            catch (MalformedURLException mfu2) {
                logger.log(Level.WARNING, "Unable to create URL for URI=[" + uri + "], with base=[" + this.getBaseURI() + "].", mfu);
                return null;
            }
        }
    }

    public final Location getLocation() {
        return this.window.getLocation();
    }

    @Override
    public void setLocation(String location) {
        this.getLocation().setHref(location);
    }

    @Override
    public String getURL() {
        return this.documentURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addStyleSheet(CSSStyleSheet ss) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.styleSheets.add(ss);
            this.styleSheetAggregator = null;
            this.forgetRenderState();
            ArrayList nl = this.nodeList;
            if (nl != null) {
                for (Object node : nl) {
                    if (!(node instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)node).forgetStyle(true);
                }
            }
        }
        this.allInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allInvalidated(boolean forgetRenderStates) {
        if (forgetRenderStates) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.styleSheetAggregator = null;
                this.forgetRenderState();
                ArrayList nl = this.nodeList;
                if (nl != null) {
                    for (Object node : nl) {
                        if (!(node instanceof HTMLElementImpl)) continue;
                        ((HTMLElementImpl)node).forgetStyle(true);
                    }
                }
            }
        }
        this.allInvalidated();
    }

    public Collection<CSSStyleSheet> getStyleSheets() {
        return this.styleSheets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StyleSheetAggregator getStyleSheetAggregator() {
        Object object = this.getTreeLock();
        synchronized (object) {
            StyleSheetAggregator ssa = this.styleSheetAggregator;
            if (ssa == null) {
                ssa = new StyleSheetAggregator(this);
                try {
                    ssa.addStyleSheets(this.styleSheets);
                }
                catch (MalformedURLException mfu) {
                    logger.log(Level.WARNING, "getStyleSheetAggregator()", mfu);
                }
                catch (UnsupportedEncodingException mfu) {
                    logger.log(Level.WARNING, "getStyleSheetAggregator()", mfu);
                }
                this.styleSheetAggregator = ssa;
            }
            return ssa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentNotificationListener(DocumentNotificationListener listener) {
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            listenersList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentNotificationListener(DocumentNotificationListener listener) {
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            listenersList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeInvalidated(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.sizeInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookInvalidated(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.lookInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionInParentInvalidated(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.positionInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidated(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.invalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void structureInvalidated(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.structureInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLoaded(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.nodeLoaded(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalScriptLoading(DOMNodeImpl node) {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.externalScriptLoading(node);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allInvalidated() {
        int size;
        ArrayList<DocumentNotificationListener> listenersList;
        ArrayList<DocumentNotificationListener> arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i = 0; i < size; ++i) {
            try {
                DocumentNotificationListener dnl = listenersList.get(i);
                dnl.allInvalidated();
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        return new StyleSheetRenderState(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(String relativeUri, ImageListener imageListener) {
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext == null || !rcontext.isImageLoadingEnabled()) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final URL url = this.getFullURL(relativeUri);
        if (url == null) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final String urlText = url.toExternalForm();
        final Map<String, ImageInfo> map = this.imageInfos;
        ImageEvent event = null;
        Map<String, ImageInfo> map2 = map;
        synchronized (map2) {
            ImageInfo info = map.get(urlText);
            if (info != null) {
                if (info.loaded) {
                    event = info.imageEvent;
                } else {
                    info.addListener(imageListener);
                }
            } else {
                UserAgentContext uac = rcontext.getUserAgentContext();
                final HttpRequest httpRequest = uac.createHttpRequest();
                final ImageInfo newInfo = new ImageInfo();
                map.put(urlText, newInfo);
                newInfo.addListener(imageListener);
                httpRequest.addReadyStateChangeListener(new ReadyStateChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void readyStateChanged() {
                        if (httpRequest.getReadyState() == 4) {
                            ImageListener[] listeners;
                            Image newImage = httpRequest.getResponseImage();
                            ImageEvent newEvent = newImage == null ? null : new ImageEvent(HTMLDocumentImpl.this, newImage);
                            Map map2 = map;
                            synchronized (map2) {
                                newInfo.imageEvent = newEvent;
                                newInfo.loaded = true;
                                listeners = newEvent == null ? null : newInfo.getListeners();
                                map.remove(urlText);
                            }
                            if (listeners != null) {
                                int llength = listeners.length;
                                for (int i = 0; i < llength; ++i) {
                                    listeners[i].imageLoaded(newEvent);
                                }
                            }
                        }
                    }
                });
                SecurityManager sm = System.getSecurityManager();
                if (sm == null) {
                    try {
                        httpRequest.open("GET", url, true);
                        httpRequest.send(null);
                    }
                    catch (IOException thrown) {
                        logger.log(Level.WARNING, "loadImage()", thrown);
                    }
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                httpRequest.open("GET", url, true);
                                httpRequest.send(null);
                            }
                            catch (IOException thrown) {
                                logger.log(Level.WARNING, "loadImage()", thrown);
                            }
                            return null;
                        }
                    });
                }
            }
        }
        if (event != null) {
            imageListener.imageLoaded(event);
        }
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        Function onloadHandler = this.onloadHandler;
        if (onloadHandler != null && "cobra.suspend".equals(key) && data == Boolean.FALSE) {
            Executor.executeFunction(this, onloadHandler, null);
        }
        return super.setUserData(key, data, handler);
    }

    @Override
    protected Node createSimilarNode() {
        return new HTMLDocumentImpl(this.ucontext, this.rcontext, this.reader, this.documentURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLElement getBody() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            return this.body;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBody(HTMLElement body) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.body = body;
        }
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String value) {
        this.referrer = value;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        String oldDomain = this.domain;
        if (oldDomain == null || !Domains.isValidCookieDomain(domain, oldDomain)) {
            throw new SecurityException("Cannot set domain to '" + domain + "' when current domain is '" + oldDomain + "'");
        }
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getImages() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.images == null) {
                this.images = new DescendentHTMLCollection(this, new ImageFilter(), this.getTreeLock());
            }
            return this.images;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getApplets() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.applets == null) {
                this.applets = new DescendentHTMLCollection(this, new AppletFilter(), this.getTreeLock());
            }
            return this.applets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getLinks() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.links == null) {
                this.links = new DescendentHTMLCollection(this, new LinkFilter(), this.getTreeLock());
            }
            return this.links;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getForms() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.forms == null) {
                this.forms = new DescendentHTMLCollection(this, new FormFilter(), this.getTreeLock());
            }
            return this.forms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getFrames() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.frames == null) {
                this.frames = new DescendentHTMLCollection(this, new FrameFilter(), this.getTreeLock());
            }
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getAnchors() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.anchors == null) {
                this.anchors = new DescendentHTMLCollection(this, new AnchorFilter(), this.getTreeLock());
            }
            return this.anchors;
        }
    }

    @Override
    public DocumentType getDoctype() {
        return this.doctype;
    }

    public void setDoctype(DocumentType doctype) {
        this.doctype = doctype;
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    public Function getOnloadHandler() {
        return this.onloadHandler;
    }

    public void setOnloadHandler(Function onloadHandler) {
        this.onloadHandler = onloadHandler;
    }

    public Set<?> getLocales() {
        return this.locales;
    }

    public void setLocales(Set<?> locales) {
        this.locales = locales;
    }

    String getDocumentHost() {
        URL docUrl = this.documentURL;
        return docUrl == null ? null : docUrl.getHost();
    }

    @Override
    public String getBaseURI() {
        String buri = this.baseURI;
        return buri == null ? this.documentURI : buri;
    }

    public void setBaseURI(String value) {
        this.baseURI = value;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String value) {
        this.defaultTarget = value;
    }

    @Override
    public AbstractView getDefaultView() {
        return this.window;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public URL getDocumentURL() {
        return this.documentURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementById(String id, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.put(id, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElementById(String id) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.remove(id);
        }
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public String getLastModified() {
        String result = "";
        try {
            SSLCertificate.setCertificate();
            URL docURL = new URL(this.documentURI);
            URLConnection connection = docURL.openConnection();
            result = connection.getHeaderField("Last-Modified");
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
        return result;
    }

    @Override
    public String getCompatMode() {
        return null;
    }

    @Override
    public String getCharacterSet() {
        NodeList nodeList = this.getElementsByTagName("META");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "charset");
        return attr.getAttribute();
    }

    @Override
    public String getDefaultCharset() {
        return Charset.defaultCharset().displayName();
    }

    @Override
    public String getReadyState() {
        return null;
    }

    @Override
    public HTMLHeadElement getHead() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getEmbeds() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.embeds == null) {
                this.embeds = new DescendentHTMLCollection(this, new EmbedFilter(), this.getTreeLock());
            }
            return this.embeds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getPlugins() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.plugins == null) {
                this.plugins = new DescendentHTMLCollection(this, new PluginsFilter(), this.getTreeLock());
            }
            return this.plugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getScripts() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.scripts == null) {
                this.scripts = new DescendentHTMLCollection(this, new ScriptFilter(), this.getTreeLock());
            }
            return this.scripts;
        }
    }

    @Override
    public NodeList getElementsByClassName(String classNames) {
        return this.getNodeList(new ClassNameFilter(classNames));
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public String getDesignMode() {
        return null;
    }

    @Override
    public void setDesignMode(String designMode) {
    }

    @Override
    public boolean execCommand(String commandId) {
        return false;
    }

    @Override
    public boolean execCommand(String commandId, boolean showUI) {
        return false;
    }

    @Override
    public boolean execCommand(String commandId, boolean showUI, String value) {
        return false;
    }

    @Override
    public boolean queryCommandEnabled(String commandId) {
        Iterator<String> it = HtmlCommandMapping.EXECUTE_CMDS.iterator();
        while (it.hasNext()) {
            if (!commandId.equalsIgnoreCase(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean queryCommandIndeterm(String commandId) {
        return false;
    }

    @Override
    public boolean queryCommandState(String commandId) {
        return false;
    }

    @Override
    public boolean queryCommandSupported(String commandId) {
        Iterator<String> it = HtmlCommandMapping.EXECUTE_CMDS.iterator();
        while (it.hasNext()) {
            if (!commandId.equalsIgnoreCase(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String queryCommandValue(String commandId) {
        return null;
    }

    @Override
    public Element querySelector(String selectors) {
        QuerySelectorImpl qsel = new QuerySelectorImpl();
        return qsel.documentQuerySelector(this.document, selectors);
    }

    @Override
    public NodeList querySelectorAll(String selectors) {
        QuerySelectorImpl qsel = new QuerySelectorImpl();
        return qsel.documentQuerySelectorAll(this.document, selectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLCollection getCommands() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.commands == null) {
                this.commands = new DescendentHTMLCollection(this, new CommandFilter(), this.getTreeLock());
            }
            return this.commands;
        }
    }

    @Override
    public String getFgColor() {
        NodeList nodeList = this.getElementsByTagName("BODY");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "text");
        return attr.getAttribute();
    }

    @Override
    public void setFgColor(String fgColor) {
        ElementAttributeFilter attr = new ElementAttributeFilter("text");
        attr.setAttribute(this, fgColor);
    }

    @Override
    public String getBgColor() {
        NodeList nodeList = this.getElementsByTagName("BODY");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "bgcolor");
        return attr.getAttribute();
    }

    @Override
    public void setBgColor(String bgColor) {
        ElementAttributeFilter attr = new ElementAttributeFilter("bgcolor");
        attr.setAttribute(this, bgColor);
    }

    @Override
    public String getLinkColor() {
        NodeList nodeList = this.getElementsByTagName("BODY");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "link");
        return attr.getAttribute();
    }

    @Override
    public void setLinkColor(String linkColor) {
        ElementAttributeFilter attr = new ElementAttributeFilter("link");
        attr.setAttribute(this, linkColor);
    }

    @Override
    public String getVlinkColor() {
        NodeList nodeList = this.getElementsByTagName("BODY");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "vlink");
        return attr.getAttribute();
    }

    @Override
    public void setVlinkColor(String vlinkColor) {
        ElementAttributeFilter attr = new ElementAttributeFilter("vlink");
        attr.setAttribute(this, vlinkColor);
    }

    @Override
    public String getAlinkColor() {
        NodeList nodeList = this.getElementsByTagName("BODY");
        ElementAttributeFilter attr = new ElementAttributeFilter(nodeList, "aLink");
        return attr.getAttribute();
    }

    @Override
    public void setAlinkColor(String alinkColor) {
        ElementAttributeFilter attr = new ElementAttributeFilter("aLink");
        attr.setAttribute(this, alinkColor);
    }

    @Override
    public void addEventListener(String script, Function function) {
        String key = script.toLowerCase();
        if (key.equals("click")) {
            this.setOnclick(function);
        } else if (key.equals("dblclick")) {
            this.setOndblclick(function);
        } else if (key.equals("mouseup")) {
            this.setOnmouseup(function);
        } else if (key.equals("mousedown")) {
            this.setOnmousedown(function);
        } else if (key.equals("mouseover")) {
            this.setOnmouseover(function);
        } else if (key.equals("mouseout")) {
            this.setOnmouseout(function);
        } else if (key.equals("keypress")) {
            this.setOnkeypress(function);
        } else if (key.equals("keyup")) {
            this.setOnkeyup(function);
        } else if (key.equals("keydown")) {
            this.setOnkeydown(function);
        } else if (key.equals("load")) {
            this.setOnloadHandler(function);
        }
    }

    @Override
    public void removeEventListener(String script, Function function) {
        String key = script.toLowerCase();
        if (key.equals("click")) {
            this.setOnclick(null);
        } else if (key.equals("dblclick")) {
            this.setOndblclick(null);
        } else if (key.equals("mouseup")) {
            this.setOnmouseup(null);
        } else if (key.equals("mousedown")) {
            this.setOnmousedown(null);
        } else if (key.equals("mouseover")) {
            this.setOnmouseover(null);
        } else if (key.equals("mouseout")) {
            this.setOnmouseout(null);
        } else if (key.equals("keypress")) {
            this.setOnkeypress(null);
        } else if (key.equals("keyup")) {
            this.setOnkeyup(null);
        } else if (key.equals("keydown")) {
            this.setOnkeydown(null);
        } else if (key.equals("load")) {
            this.setOnloadHandler(null);
        }
    }

    @Override
    public void addEventListener(String script, Function function, boolean bool) {
        this.addEventListener(script, function);
    }

    @Override
    public void removeEventListener(String script, Function function, boolean bool) {
        this.removeEventListener(script, function);
    }

    public Function getOnclick() {
        return this.onclick;
    }

    public void setOnclick(Function onclick) {
        this.onclick = onclick;
    }

    public Function getOnunload() {
        return this.onunload;
    }

    public void setOnunload(Function onunload) {
        this.onunload = onunload;
    }

    public Function getOnmousedown() {
        return this.onmousedown;
    }

    public void setOnmousedown(Function onmousedown) {
        this.onmousedown = onmousedown;
    }

    public Function getOnkeypress() {
        return this.onkeypress;
    }

    public void setOnkeypress(Function onkeypress) {
        this.onkeypress = onkeypress;
    }

    public Function getOnkeydown() {
        return this.onkeydown;
    }

    public void setOnkeydown(Function onkeydown) {
        this.onkeydown = onkeydown;
    }

    public Function getOnmouseup() {
        return this.onmouseup;
    }

    public void setOnmouseup(Function onmouseup) {
        this.onmouseup = onmouseup;
    }

    public Function getOndblclick() {
        return this.ondblclick;
    }

    public void setOndblclick(Function ondblclick) {
        this.ondblclick = ondblclick;
    }

    public Function getOnkeyup() {
        return this.onkeyup;
    }

    public void setOnkeyup(Function onkeyup) {
        this.onkeyup = onkeyup;
    }

    public Function getOnmouseout() {
        return this.onmouseout;
    }

    public void setOnmouseout(Function onmouseout) {
        this.onmouseout = onmouseout;
    }

    public Function getOnmouseover() {
        return this.onmouseover;
    }

    public void setOnmouseover(Function onmouseover) {
        this.onmouseover = onmouseover;
    }

    static {
        logger.setLevel(Level.SEVERE);
    }

    private class LocalWritableLineReader
    extends WritableLineReader {
        public LocalWritableLineReader(LineNumberReader reader) {
            super(reader);
        }

        public LocalWritableLineReader(Reader reader) {
            super(reader);
        }

        @Override
        public void write(String text) throws IOException {
            super.write(text);
            if ("".equals(text)) {
                HTMLDocumentImpl.this.openBufferChanged(text);
            }
        }
    }
}

