/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.dombl;

import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.lobobrowser.html.dombl.ImageListener;
import org.lobobrowser.util.SimpleThreadPool;

public class SVGRasterizer {
    private static final Logger logger = Logger.getLogger(SVGRasterizer.class.getName());
    private TranscoderInput input;
    protected TranscodingHints hints = new TranscodingHints();
    private static SimpleThreadPool threadPool = new SimpleThreadPool("SVGFetchThreadPool", 0, 1, 2000);
    private ImageListener imageLoadedCallback = null;

    private SVGRasterizer(TranscoderInput transcoderInput) {
        this.input = transcoderInput;
    }

    public SVGRasterizer(String uri) {
        this(new TranscoderInput(uri));
    }

    public SVGRasterizer(URL url) {
        this.input = new TranscoderInput(url.toString());
    }

    public SVGRasterizer(InputStream istream) {
        this(new TranscoderInput(istream));
    }

    public SVGRasterizer(Reader reader) {
        this(new TranscoderInput(reader));
    }

    public void setImageLoadedCallback(ImageListener imageListener) {
        this.imageLoadedCallback = imageListener;
    }

    public BufferedImage createBufferedImage() {
        return null;
    }

    public Image bufferedImageToImage() throws TranscoderException {
        return this.createBufferedImage();
    }

    public void setImageWidth(float width) {
        this.hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)new Float(width));
    }

    public void setImageHeight(float height) {
        this.hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)new Float(height));
    }

    public void setLanguages(String language) {
        this.hints.put((Object)ImageTranscoder.KEY_LANGUAGE, (Object)language);
    }

    public void setPixelToMMFactor(float px2mm) {
        this.hints.put((Object)ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(px2mm));
    }

    public void setUserStyleSheetURI(String uri) {
        this.hints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)uri);
    }

    public void setXMLParserValidating(boolean b) {
        this.hints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setMedia(String media) {
        this.hints.put((Object)ImageTranscoder.KEY_MEDIA, (Object)media);
    }

    public void setAlternateStylesheet(String alternateStylesheet) {
        this.hints.put((Object)ImageTranscoder.KEY_ALTERNATE_STYLESHEET, (Object)alternateStylesheet);
    }

    public void setBackgroundColor(Paint p) {
        this.hints.put((Object)ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)p);
    }

    protected class Rasterizer
    extends ImageTranscoder {
        private BufferedImage image;

        public Rasterizer(BufferedImage image) {
            this.image = image;
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(final BufferedImage img, TranscoderOutput output) throws TranscoderException {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SVGRasterizer.this.imageLoadedCallback != null) {
                        Rasterizer.this.image = img;
                    } else {
                        Rasterizer.this.image.setData(img.getData());
                    }
                }
            });
        }
    }
}

