/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.dombl;

import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChildHTMLCollection
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final DOMNodeImpl rootNode;

    public ChildHTMLCollection(DOMNodeImpl node) {
        this.rootNode = node;
    }

    @Override
    public int getLength() {
        return this.rootNode.getChildCount();
    }

    @Override
    public Node item(int index) {
        return this.rootNode.getChildAtIndex(index);
    }

    @Override
    public Node namedItem(String name) {
        Document doc = this.rootNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        Element node = doc.getElementById(name);
        if (node != null && node.getParentNode() == this.rootNode) {
            return node;
        }
        return null;
    }

    public int indexOf(Node node) {
        return this.rootNode.getChildIndex(node);
    }
}

