/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.JTextComponent;
import org.lobobrowser.html.control.BaseInputTextControl;
import org.lobobrowser.html.dombl.JTextFieldImpl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.HtmlController;

public class InputTextControl
extends BaseInputTextControl {
    private static final long serialVersionUID = 1L;

    public InputTextControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        JTextFieldImpl text = (JTextFieldImpl)this.widget;
        if (modelNode.getTitle() != null) {
            text.setToolTipText(modelNode.getTitle());
        }
        text.setVisible(modelNode.getHidden());
        text.applyComponentOrientation(this.direction(modelNode.getDir()));
        text.setEditable(new Boolean(modelNode.getContentEditable() == null ? "true" : modelNode.getContentEditable()));
        text.setEnabled(!modelNode.getDisabled());
        text.setPlaceholder(modelNode.getPlaceholder());
        text.setSelectionColor(Color.BLUE);
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onEnterPressed(modelNode, null);
            }
        });
    }

    @Override
    protected JTextComponent createTextField() {
        return new JTextFieldImpl();
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

