/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.dombl.JTextAreaImpl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.gui.WrapperLayout;

public class InputTextAreaControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private final JTextAreaImpl widget;
    private int cols = -1;
    private int rows = -1;

    public InputTextAreaControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        JTextAreaImpl widget;
        this.setLayout(WrapperLayout.getInstance());
        this.widget = widget = (JTextAreaImpl)this.createTextField();
        this.add(new JScrollPane(widget));
        HTMLElementImpl element = this.controlElement;
        String value = element.getTextContent();
        widget.setLineWrap(true);
        if (modelNode.getTitle() != null) {
            widget.setToolTipText(modelNode.getTitle());
        }
        widget.setVisible(modelNode.getHidden());
        widget.applyComponentOrientation(this.direction(modelNode.getDir()));
        widget.setEditable(new Boolean(modelNode.getContentEditable() == null ? "true" : modelNode.getContentEditable()));
        widget.setEnabled(!modelNode.getDisabled());
        widget.setPlaceholder(modelNode.getPlaceholder());
        widget.setSelectionColor(Color.BLUE);
        widget.setText(value);
        widget.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                HtmlController.getInstance().onKeyDown(modelNode, event);
                HtmlController.getInstance().onKeyPress(modelNode, event);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                HtmlController.getInstance().onKeyUp(modelNode, event);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        String rowsStr;
        super.reset(availWidth, availHeight);
        HTMLElementImpl element = this.controlElement;
        String colsStr = element.getAttribute("cols");
        if (colsStr != null) {
            try {
                this.setCols(Integer.parseInt(colsStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((rowsStr = element.getAttribute("rows")) != null) {
            try {
                this.setRows(Integer.parseInt(rowsStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected JTextComponent createTextField() {
        return new JTextAreaImpl();
    }

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public void setCols(int cols) {
        if (cols != this.cols) {
            this.cols = cols;
            this.invalidate();
        }
    }

    @Override
    public void setRows(int rows) {
        if (rows != this.rows) {
            this.rows = rows;
            this.invalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int ph;
        int pw;
        int cols = this.cols;
        if (cols == -1) {
            pw = 100;
        } else {
            Font f = this.widget.getFont();
            FontMetrics fm = this.widget.getFontMetrics(f);
            Insets insets = this.widget.getInsets();
            pw = insets.left + insets.right + fm.charWidth('*') * cols;
        }
        int rows = this.rows;
        if (rows == -1) {
            ph = 100;
        } else {
            Font f = this.widget.getFont();
            FontMetrics fm = this.widget.getFontMetrics(f);
            Insets insets = this.widget.getInsets();
            ph = insets.top + insets.bottom + fm.getHeight() * rows;
        }
        return new Dimension(pw, ph);
    }

    @Override
    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    @Override
    public String getValue() {
        String text = this.widget.getText();
        return Strings.getCRLFString(text);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.widget.setEditable(readOnly);
    }

    @Override
    public void setValue(String value) {
        this.widget.setText(value);
    }

    @Override
    public void resetInput() {
        this.widget.setText("");
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

