/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.lobobrowser.html.control.BaseInputTextControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.HtmlController;

public class InputPasswordControl
extends BaseInputTextControl {
    private static final long serialVersionUID = 1L;

    public InputPasswordControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        JPasswordField pwd = (JPasswordField)this.widget;
        if (modelNode.getTitle() != null) {
            pwd.setToolTipText(modelNode.getTitle());
        }
        pwd.setVisible(modelNode.getHidden());
        pwd.applyComponentOrientation(this.direction(modelNode.getDir()));
        pwd.setEditable(new Boolean(modelNode.getContentEditable() == null ? "true" : modelNode.getContentEditable()));
        pwd.setEnabled(!modelNode.getDisabled());
        pwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onEnterPressed(modelNode, null);
            }
        });
    }

    @Override
    protected JTextComponent createTextField() {
        return new JPasswordField();
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }
}

