/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;

public class InputFileControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private final JTextField textField = new JTextField();
    private final JButton browseButton = new JButton();
    private File[] filesValue;

    public InputFileControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(new BoxLayout(this, 0));
        JButton browseButton = this.browseButton;
        browseButton.setAction(new BrowseAction());
        browseButton.setText("Browse");
        Dimension ps = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(128, ps.height));
        this.textField.setEditable(false);
        if (modelNode.getTitle() != null) {
            this.textField.setToolTipText(modelNode.getTitle());
        }
        this.textField.setVisible(modelNode.getHidden());
        this.textField.applyComponentOrientation(this.direction(modelNode.getDir()));
        this.textField.setEditable(new Boolean(modelNode.getContentEditable() == null ? "true" : modelNode.getContentEditable()));
        this.textField.setEnabled(!modelNode.getDisabled());
        this.add(this.textField);
        this.add(Box.createHorizontalStrut(4));
        this.add(browseButton);
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.browseButton.setEnabled(!disabled);
    }

    @Override
    public void setValue(String value) {
    }

    private void setFileValue(File[] files) {
        this.filesValue = files;
        if (files == null) {
            this.textField.setText("");
        } else {
            String paths = "";
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                paths = paths + paths + ";" + f.getAbsolutePath();
            }
            this.textField.setText(paths);
        }
    }

    @Override
    public File[] getFileValue() {
        return this.filesValue;
    }

    @Override
    public void resetInput() {
        this.setFileValue(null);
    }

    private ComponentOrientation direction(String dir) {
        if ("ltr".equalsIgnoreCase(dir)) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        if ("rtl".equalsIgnoreCase(dir)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.UNKNOWN;
    }

    private class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private BrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            if (chooser.showOpenDialog(InputFileControl.this) == 0) {
                InputFileControl.this.setFileValue(chooser.getSelectedFiles());
            } else {
                InputFileControl.this.setFileValue(null);
            }
        }
    }
}

