/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.transcoder.TranscoderException;
import org.lobobrowser.html.control.BaseControl;
import org.lobobrowser.html.dombl.ImageEvent;
import org.lobobrowser.html.dombl.ImageListener;
import org.lobobrowser.html.dombl.SVGRasterizer;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlValues;

public class ImgControl
extends BaseControl
implements ImageListener {
    private static final long serialVersionUID = 1L;
    private volatile Image image;
    private int valign = 5;
    private Dimension preferredSize;
    private int declaredWidth;
    private int declaredHeight;
    private String lastSrc;
    private String align;
    private String alt;
    private int imageWidth;
    private int imageHeight;
    private boolean mouseBeingPressed;

    public ImgControl(final HTMLImageElementImpl modelNode) {
        super(modelNode);
        this.align = modelNode.getAlign();
        this.alt = modelNode.getAlt() != null ? modelNode.getAlt() : "";
        modelNode.addImageListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ImgControl.this.mouseBeingPressed = true;
                ImgControl.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ImgControl.this.mouseBeingPressed = false;
                ImgControl.this.repaint();
                HtmlController.getInstance().onPressed(modelNode, e, e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    HtmlController.getInstance().onContextMenu(modelNode, e, e.getX(), e.getY());
                }
            }
        });
        if (modelNode.getSrc() != null && modelNode.getSrc().endsWith(".svg")) {
            try {
                URL u = new URL(modelNode.getSrc());
                SVGRasterizer r = new SVGRasterizer(u);
                r.setImageLoadedCallback(this);
                this.image = r.bufferedImageToImage();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (TranscoderException e1) {
                e1.printStackTrace();
            }
        }
        if (modelNode.getHeight() > 0) {
            this.imageHeight = modelNode.getHeight();
        } else if (this.image != null) {
            this.imageHeight = this.image.getHeight(this);
        }
        if (modelNode.getWidth() > 0) {
            this.imageWidth = modelNode.getWidth();
        } else if (this.image != null) {
            this.imageWidth = this.image.getWidth(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Color over;
        super.paintComponent(g);
        if (this.image != null) {
            int x = (this.getWidth() - this.imageWidth) / 2;
            int y = (this.getHeight() - this.imageHeight) / 2;
            g.drawImage(this.image, x, y, this.imageWidth, this.imageHeight, this);
        } else {
            g.drawString(this.alt, 10, 10);
        }
        if (this.mouseBeingPressed && (over = new Color(255, 100, 100, 64)) != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, this.imageWidth, this.imageHeight);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        int valign;
        int dw = HtmlValues.getOldSyntaxPixelSize(String.valueOf(this.imageWidth), availWidth, -1);
        int dh = HtmlValues.getOldSyntaxPixelSize(String.valueOf(this.imageHeight), availHeight, -1);
        this.declaredWidth = dw;
        this.declaredHeight = dh;
        this.preferredSize = this.createPreferredSize(dw, dh);
        if (this.align == null) {
            valign = 5;
        } else {
            this.align = this.align.toLowerCase().trim();
            valign = "middle".equals(this.align) ? 1 : ("absmiddle".equals(this.align) ? 3 : ("top".equals(this.align) ? 0 : ("bottom".equals(this.align) ? 2 : ("baseline".equals(this.align) ? 5 : ("absbottom".equals(this.align) ? 4 : 5)))));
        }
        this.valign = valign;
    }

    @Override
    public int getVAlign() {
        return this.valign;
    }

    public Dimension createPreferredSize(int dw, int dh) {
        int ih;
        int iw;
        Image img = this.image;
        if (dw == -1) {
            if (dh != -1) {
                iw = img == null ? -1 : img.getWidth(this);
                int n = ih = img == null ? -1 : img.getHeight(this);
                dw = ih == 0 ? (iw == -1 ? 0 : iw) : (iw == -1 || ih == -1 ? 0 : dh * iw / ih);
            } else {
                int n = dw = img == null ? -1 : img.getWidth(this);
                if (dw == -1) {
                    dw = 0;
                }
            }
        }
        if (dh == -1) {
            if (dw != -1) {
                iw = img == null ? -1 : img.getWidth(this);
                int n = ih = img == null ? -1 : img.getHeight(this);
                dh = iw == 0 ? (ih == -1 ? 0 : ih) : (iw == -1 || ih == -1 ? 0 : dw * ih / iw);
            } else {
                int n = dh = img == null ? -1 : img.getHeight(this);
                if (dh == -1) {
                    dh = 0;
                }
            }
        }
        return new Dimension(dw, dh);
    }

    private final boolean checkPreferredSizeChange() {
        Dimension newPs = this.createPreferredSize(this.declaredWidth, this.declaredHeight);
        Dimension ps = this.preferredSize;
        if (ps == null) {
            return true;
        }
        if (ps.width != newPs.width || ps.height != newPs.height) {
            this.preferredSize = newPs;
            return true;
        }
        return false;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ImgControl.this.checkPreferredSizeChange()) {
                        ImgControl.this.repaint();
                    } else {
                        ImgControl.this.ruicontrol.preferredSizeInvalidated();
                    }
                }
            });
        }
        return true;
    }

    public void imageUpdate(Image img, int w, int h) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ImgControl.this.checkPreferredSizeChange()) {
                    ImgControl.this.repaint();
                } else {
                    ImgControl.this.ruicontrol.preferredSizeInvalidated();
                }
            }
        });
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    @Override
    public void imageLoaded(ImageEvent event) {
        Image image;
        this.image = image = event.image;
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width != -1 && height != -1) {
            this.imageUpdate(image, width, height);
        }
    }

    @Override
    public String toString() {
        return "ImgControl[src=" + this.lastSrc + "]";
    }
}

