/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;

public abstract class BaseInputTextControl
extends BaseInputControl {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_FONT_SIZE = 14.0f;
    protected final JTextComponent widget;
    private int maxLength = -1;

    protected abstract JTextComponent createTextField();

    public BaseInputTextControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JTextComponent widget = this.createTextField();
        Font font = widget.getFont();
        widget.setFont(font.deriveFont(14.0f));
        widget.setDocument(new LimitedDocument());
        widget.setSelectionColor(Color.BLUE);
        HTMLElementImpl element = this.controlElement;
        widget.setText(element.getAttribute("value"));
        widget.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                HtmlController.getInstance().onKeyDown(modelNode, event);
                HtmlController.getInstance().onKeyPress(modelNode, event);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                HtmlController.getInstance().onKeyUp(modelNode, event);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.widget = widget;
        this.add(widget);
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        String maxLengthText = this.controlElement.getAttribute("maxlength");
        if (maxLengthText != null) {
            try {
                this.maxLength = Integer.parseInt(maxLengthText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    @Override
    public String getValue() {
        return this.widget.getText();
    }

    @Override
    public void select() {
        this.widget.selectAll();
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.widget.setEditable(!readOnly);
    }

    @Override
    public void setValue(String value) {
        this.widget.setText(value);
    }

    @Override
    public Dimension getPreferredSize() {
        int size = this.size;
        JTextComponent widget = this.widget;
        FontMetrics fm = widget.getFontMetrics(widget.getFont());
        Insets insets = widget.getInsets();
        int pw = size == -1 ? 200 : insets.left + insets.right + fm.charWidth('0') * size;
        int ph = fm.getHeight() + insets.top;
        return new Dimension(pw, ph);
    }

    @Override
    public void resetInput() {
        this.widget.setText("");
    }

    private class LimitedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private LimitedDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int max = BaseInputTextControl.this.maxLength;
            if (max != -1) {
                int docLength = this.getLength();
                if (docLength >= max) {
                    return;
                }
                int strLen = str.length();
                if (docLength + strLen > max) {
                    String shorterStr = str.substring(0, max - docLength);
                    super.insertString(offs, shorterStr, a);
                } else {
                    super.insertString(offs, str, a);
                }
            } else {
                super.insertString(offs, str, a);
            }
        }
    }
}

