/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.context;

import java.util.LinkedList;
import java.util.List;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ClientletSelector;
import org.lobobrowser.context.CoreClientletSelector;
import org.lobobrowser.security.GenericLocalPermission;

public class ClientletFactory {
    private static ClientletFactory instance;
    private final List<ClientletSelector> selectors = new LinkedList<ClientletSelector>();

    private ClientletFactory() {
        this.addClientletSelector(new CoreClientletSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientletFactory getInstance() {
        if (instance != null) return instance;
        Class<ClientletFactory> clazz = ClientletFactory.class;
        synchronized (ClientletFactory.class) {
            if (instance != null) return instance;
            instance = new ClientletFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientletSelector(ClientletSelector selector) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        ClientletFactory clientletFactory = this;
        synchronized (clientletFactory) {
            this.selectors.add(0, selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clientlet getClientlet(ClientletRequest request, ClientletResponse response) {
        ClientletFactory clientletFactory = this;
        synchronized (clientletFactory) {
            for (ClientletSelector selector : this.selectors) {
                Clientlet clientlet = selector.select(request, response);
                if (clientlet == null) continue;
                return clientlet;
            }
        }
        throw new IllegalStateException("No clientlets found for response: " + response + ".");
    }
}

