/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.context;

import java.awt.Component;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.clientlet.ContentBuffer;
import org.lobobrowser.clientlet.SimpleComponentContent;
import org.lobobrowser.context.NetworkRequestImpl;
import org.lobobrowser.context.VolatileContentImpl;
import org.lobobrowser.io.ManagedStore;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.store.StorageManager;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NetworkRequest;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.UserAgent;
import org.lobobrowser.util.Urls;

public class ClientletContextImpl
implements ClientletContext {
    private final NavigatorFrame frame;
    private final ClientletRequest request;
    private final ClientletResponse response;
    private Map<String, Object> items = null;
    private volatile ComponentContent resultingContent;
    private volatile Properties windowProperties;

    public ClientletContextImpl(NavigatorFrame frame, ClientletRequest request, ClientletResponse response) {
        this.frame = frame;
        this.request = request;
        this.response = response;
    }

    @Override
    public ContentBuffer createContentBuffer(String contentType, byte[] content) {
        return new VolatileContentImpl(contentType, content);
    }

    @Override
    public ContentBuffer createContentBuffer(String contentType, String content, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = content.getBytes(encoding);
        return new VolatileContentImpl(contentType, bytes);
    }

    @Override
    public NavigatorFrame getNavigatorFrame() {
        return this.frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getItem(String name) {
        ClientletContextImpl clientletContextImpl = this;
        synchronized (clientletContextImpl) {
            Map<String, Object> items = this.items;
            if (items == null) {
                return null;
            }
            return items.get(name);
        }
    }

    @Override
    public ManagedStore getManagedStore() throws IOException {
        ClientletResponse response = this.response;
        if (response == null) {
            throw new SecurityException("There is no client response");
        }
        String hostName = response.getResponseURL().getHost();
        return StorageManager.getInstance().getRestrictedStore(hostName, true);
    }

    @Override
    public ManagedStore getManagedStore(String hostName) throws IOException {
        return StorageManager.getInstance().getRestrictedStore(hostName, true);
    }

    @Override
    public ClientletRequest getRequest() {
        return this.request;
    }

    @Override
    public ClientletResponse getResponse() {
        return this.response;
    }

    @Override
    public UserAgent getUserAgent() {
        return UserAgentImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String name, Object value) {
        ClientletContextImpl clientletContextImpl = this;
        synchronized (clientletContextImpl) {
            Map<String, Object> items = this.items;
            if (items == null) {
                this.items = items = new HashMap<String, Object>(1);
            }
            items.put(name, value);
        }
    }

    @Override
    public ComponentContent getResultingContent() {
        return this.resultingContent;
    }

    @Override
    public void navigate(String url) throws IOException {
        URL responseURL = this.response.getResponseURL();
        URL newURL = Urls.guessURL(responseURL, url);
        this.frame.navigate(newURL);
    }

    @Override
    public final void setResultingContent(Component content) {
        this.setResultingContent(new SimpleComponentContent(content));
    }

    @Override
    public void setResultingContent(ComponentContent content) {
        this.resultingContent = content;
    }

    @Override
    public void overrideWindowProperties(Properties properties) {
        this.windowProperties = properties;
    }

    @Override
    public Properties getOverriddingWindowProperties() {
        return this.windowProperties;
    }

    @Override
    public boolean isResultingContentSet() {
        return this.resultingContent != null;
    }

    @Override
    public void setProgressEvent(ProgressType progressType, int value, int max) {
        this.setProgressEvent(progressType, value, max, this.getResponse().getResponseURL());
    }

    @Override
    public NavigatorProgressEvent getProgressEvent() {
        return this.frame.getProgressEvent();
    }

    @Override
    public void setProgressEvent(ProgressType progressType, int value, int max, URL url) {
        ClientletResponse response = this.getResponse();
        NavigatorFrame frame = this.getNavigatorFrame();
        String method = response.getLastRequestMethod();
        frame.setProgressEvent(new NavigatorProgressEvent(this, frame, progressType, url, method, value, max));
    }

    @Override
    public void setProgressEvent(NavigatorProgressEvent event) {
        this.getNavigatorFrame().setProgressEvent(event);
    }

    @Override
    public NetworkRequest createNetworkRequest() {
        return new NetworkRequestImpl();
    }

    @Override
    public void alert(String message) {
        this.getNavigatorFrame().alert(message);
    }

    @Override
    public NavigatorFrame createNavigatorFrame() {
        return this.getNavigatorFrame().createFrame();
    }
}

