/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.async;

import java.awt.EventQueue;
import java.util.EventObject;
import org.lobobrowser.async.AsyncResult;
import org.lobobrowser.async.AsyncResultEvent;
import org.lobobrowser.async.AsyncResultListener;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Objects;

public class AsyncResultImpl<TResult>
implements AsyncResult<TResult> {
    private final EventDispatch evtResult = new EventDispatch();
    private TResult result;
    private Throwable exception;
    private boolean hasResult = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(final AsyncResultListener<TResult> listener) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.hasResult) {
                if (this.exception != null) {
                    final Throwable exception = this.exception;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AsyncResultEvent<Throwable> are = new AsyncResultEvent<Throwable>(AsyncResultImpl.this, exception);
                            listener.exceptionReceived(are);
                        }
                    });
                } else {
                    final TResult result = this.result;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AsyncResultEvent<Object> are = new AsyncResultEvent<Object>(AsyncResultImpl.this, result);
                            listener.resultReceived(are);
                        }
                    });
                }
            }
            this.evtResult.addListener(new EventListenerWrapper<TResult>(listener));
        }
    }

    @Override
    public void removeResultListener(AsyncResultListener<TResult> listener) {
        this.evtResult.removeListener(new EventListenerWrapper<TResult>(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.hasResult) {
                if (this.exception != null) {
                    final Throwable exception = this.exception;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AsyncResultEvent<Throwable> are = new AsyncResultEvent<Throwable>(AsyncResultImpl.this, exception);
                            AsyncResultImpl.this.evtResult.fireEvent(are);
                        }
                    });
                } else {
                    final TResult result = this.result;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AsyncResultEvent<Object> are = new AsyncResultEvent<Object>(AsyncResultImpl.this, result);
                            AsyncResultImpl.this.evtResult.fireEvent(are);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(final TResult result) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.result = result;
            this.hasResult = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AsyncResultImpl.this.evtResult.fireEvent(new AsyncResultEvent<Object>(AsyncResultImpl.this, result));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(final Throwable exception) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.exception = exception;
            this.hasResult = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AsyncResultImpl.this.evtResult.fireEvent(new AsyncResultEvent<Throwable>(AsyncResultImpl.this, exception));
                }
            });
        }
    }

    private static class EventListenerWrapper<TR>
    implements GenericEventListener {
        private final AsyncResultListener<TR> listener;

        public EventListenerWrapper(AsyncResultListener<TR> listener) {
            this.listener = listener;
        }

        @Override
        public void processEvent(EventObject event) {
            AsyncResultEvent are = (AsyncResultEvent)event;
            if (are.getResult() instanceof Exception) {
                this.listener.exceptionReceived(are);
            } else {
                this.listener.resultReceived(are);
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof EventListenerWrapper)) {
                return false;
            }
            EventListenerWrapper elw = (EventListenerWrapper)other;
            return Objects.equals(elw.listener, this.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

