/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.gwt;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.server.integration.AppEngineServerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import icons.GoogleAppEngineIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppEngineGwtServer
extends GwtDevModeServer {
    private final ApplicationServer myServer;

    public AppEngineGwtServer(@NotNull ApplicationServer server) {
        if (server == null) {
            AppEngineGwtServer.$$$reportNull$$$0(0);
        }
        super("app-engine:" + server.getName(), server.getName());
        this.myServer = server;
    }

    public Icon getIcon() {
        return GoogleAppEngineIcons.AppEngine;
    }

    public void patchParameters(@NotNull JavaParameters parameters, String originalOutputDir, @NotNull GwtFacet gwtFacet) {
        if (parameters == null) {
            AppEngineGwtServer.$$$reportNull$$$0(1);
        }
        if (gwtFacet == null) {
            AppEngineGwtServer.$$$reportNull$$$0(2);
        }
        ParametersList programParameters = parameters.getProgramParametersList();
        programParameters.add("-server");
        programParameters.add("com.google.appengine.tools.development.gwt.AppEngineLauncher");
        AppEngineSdk sdk = ((AppEngineServerData)this.myServer.getPersistentData()).getSdk();
        sdk.patchJavaParametersForDevServer(parameters.getVMParametersList());
        for (File jar : (File[])ArrayUtil.mergeArrays((Object[])sdk.getLibraries(), (Object[])sdk.getJspLibraries())) {
            parameters.getClassPath().addFirst(FileUtil.toSystemIndependentName((String)jar.getAbsolutePath()));
        }
        parameters.getClassPath().add(sdk.getToolsApiJarFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtFacet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/appengine/gwt/AppEngineGwtServer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "patchParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

