/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.appengine.model.PersistenceApi;

public class PersistenceApiComboboxUtil {
    @NonNls
    public static final String NONE_ITEM = "None";

    private PersistenceApiComboboxUtil() {
    }

    public static void setComboboxModel(JComboBox comboBox, boolean addNoneItem) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (addNoneItem) {
            model.addElement(NONE_ITEM);
        }
        for (PersistenceApi api : PersistenceApi.values()) {
            model.addElement(api.getDisplayName());
        }
        comboBox.setModel(model);
    }

    @Nullable
    public static PersistenceApi getSelectedApi(JComboBox comboBox) {
        String apiName = (String)comboBox.getSelectedItem();
        PersistenceApi api = null;
        for (PersistenceApi value : PersistenceApi.values()) {
            if (!value.getDisplayName().equals(apiName)) continue;
            api = value;
        }
        return api;
    }
}

