/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.cloud;

import com.intellij.appengine.cloud.AppEngineServerConfiguration;
import com.intellij.appengine.facet.AppEngineAccountDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineCloudConfigurable
extends RemoteServerConfigurable
implements Configurable {
    public static final String EMAIL_KEY = "GOOGLE_APP_ENGINE_ACCOUNT_EMAIL";
    private final AppEngineServerConfiguration myConfiguration;
    @Nullable
    private final Project myProject;
    private JTextField myEmailField;
    private JBPasswordField myPasswordField;
    private JBRadioButton myPasswordLoginButton;
    private JBRadioButton myOAuthLoginButton;
    private JPanel myMainPanel;
    private JCheckBox myRememberPasswordCheckBox;
    private final boolean myAlwaysRememberPassword;

    public AppEngineCloudConfigurable(@NotNull AppEngineServerConfiguration configuration, @Nullable Project project, boolean alwaysRememberPassword) {
        if (configuration == null) {
            AppEngineCloudConfigurable.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        this.myProject = project;
        this.$$$setupUI$$$();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AppEngineCloudConfigurable.this.updateControls();
            }
        };
        this.myPasswordLoginButton.addActionListener(actionListener);
        this.myOAuthLoginButton.addActionListener(actionListener);
        DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                AppEngineCloudConfigurable.this.updateControls();
            }
        };
        this.myEmailField.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myAlwaysRememberPassword = alwaysRememberPassword;
        this.updateControls();
    }

    private void updateControls() {
        boolean passwordLogin = this.myPasswordLoginButton.isSelected();
        this.myEmailField.setEnabled(passwordLogin);
        this.myPasswordField.setEnabled(passwordLogin);
        this.myRememberPasswordCheckBox.setEnabled(passwordLogin);
        if (passwordLogin && this.myAlwaysRememberPassword && !this.getPassword().isEmpty()) {
            this.myRememberPasswordCheckBox.setSelected(true);
            this.myRememberPasswordCheckBox.setEnabled(false);
        }
    }

    public String getEmail() {
        return StringUtil.nullize((String)this.myEmailField.getText(), (boolean)true);
    }

    public boolean canCheckConnection() {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return "Google App Engine Account";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public void reset() {
        String email = this.myConfiguration.getEmail();
        if (email == null) {
            email = AppEngineCloudConfigurable.getOldEmail();
        }
        this.myEmailField.setText(StringUtil.notNullize((String)email));
        if (this.myConfiguration.isOAuth2()) {
            this.myOAuthLoginButton.setSelected(true);
        } else {
            this.myPasswordLoginButton.setSelected(true);
        }
        this.myRememberPasswordCheckBox.setSelected(this.myConfiguration.isPasswordStored());
        this.myPasswordField.setPasswordIsStored(this.myConfiguration.isPasswordStored());
        this.updateControls();
    }

    @Nullable
    private static String getOldEmail() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            String value = PropertiesComponent.getInstance((Project)project).getValue(EMAIL_KEY);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static void removeOldEmail(@NotNull String email) {
        if (email == null) {
            AppEngineCloudConfigurable.$$$reportNull$$$0(1);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            String value = PropertiesComponent.getInstance((Project)project).getValue(EMAIL_KEY);
            if (!email.equals(value)) continue;
            PropertiesComponent.getInstance((Project)project).unsetValue(EMAIL_KEY);
        }
    }

    public void apply() {
        String email = this.getEmail();
        if (email != null) {
            AppEngineCloudConfigurable.removeOldEmail(email);
        }
        this.myConfiguration.setEmail(email);
        this.myConfiguration.setOAuth2(this.isOAuth2());
        String password = this.getPassword();
        if (this.myRememberPasswordCheckBox.isSelected() && !StringUtil.isEmpty((String)email) && !password.isEmpty()) {
            AppEngineAccountDialog.storePassword(email, password);
            this.myConfiguration.setPasswordStored(true);
        } else {
            this.myConfiguration.setPasswordStored(false);
        }
    }

    public boolean isOAuth2() {
        return this.myOAuthLoginButton.isSelected();
    }

    public String getPassword() {
        return new String(this.myPasswordField.getPassword());
    }

    public boolean isModified() {
        return !Comparing.strEqual((String)this.getEmail(), (String)this.myConfiguration.getEmail()) || this.myConfiguration.isOAuth2() != this.isOAuth2() || this.myRememberPasswordCheckBox.isSelected() != this.myConfiguration.isPasswordStored() || this.myRememberPasswordCheckBox.isSelected() && !this.getPassword().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
        }
        objectArray2[1] = "com/intellij/appengine/cloud/AppEngineCloudConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeOldEmail";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBPasswordField jBPasswordField;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Email:");
        jLabel.setDisplayedMnemonic('E');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myEmailField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Password:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myPasswordField = jBPasswordField = new JBPasswordField();
        jPanel.add((Component)jBPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordLoginButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Log in with email and password");
        jBRadioButton2.setMnemonic('L');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOAuthLoginButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setSelected(true);
        jBRadioButton.setText("Use passwordless login via OAuth2");
        jBRadioButton.setMnemonic('U');
        jBRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRememberPasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remember password");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        ((Component)jCheckBox).setVisible(true);
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

