/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.actions;

import com.intellij.appengine.cloud.AppEngineCloudType;
import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadApplicationAction
extends AnAction {
    public static final String LAST_RUN_CONFIGURATION_PROPERTY = "JAVA_APP_ENGINE_LAST_RUN_CONFIGURATION";

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AppEngineFacet.ID));
        if (project != null) {
            RunnerAndConfigurationSettings configurationToRun = UploadApplicationAction.getConfigurationToRun(project);
            String text = configurationToRun == null ? this.getTemplatePresentation().getText() : "Upload App Engine Application '" + configurationToRun.getName() + "'";
            e.getPresentation().setText(text);
        }
    }

    @Nullable
    private static RunnerAndConfigurationSettings getConfigurationToRun(@NotNull Project project) {
        if (project == null) {
            UploadApplicationAction.$$$reportNull$$$0(0);
        }
        List configurations = DeploymentConfigurationManager.getInstance((Project)project).getDeploymentConfigurations((ServerType)AppEngineCloudType.getInstance());
        String lastName = PropertiesComponent.getInstance((Project)project).getValue(LAST_RUN_CONFIGURATION_PROPERTY);
        if (lastName != null) {
            for (RunnerAndConfigurationSettings configuration : configurations) {
                if (!configuration.getName().equals(lastName)) continue;
                return configuration;
            }
        }
        return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)configurations);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        RunnerAndConfigurationSettings configurationToRun = UploadApplicationAction.getConfigurationToRun(project);
        if (configurationToRun != null) {
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configurationToRun, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        } else {
            AppEngineCloudType serverType = AppEngineCloudType.getInstance();
            List servers = RemoteServersManager.getInstance().getServers((ServerType)serverType);
            DeploymentConfigurationManager.getInstance((Project)project).createAndRunConfiguration((ServerType)serverType, (RemoteServer)ContainerUtil.getFirstItem((List)servers), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/actions/UploadApplicationAction", "getConfigurationToRun"));
    }
}

