/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.providers;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CdiImplicitUsageProvider
implements ImplicitUsageProvider {
    private static Collection<String> PARAM_ANNOS = ContainerUtil.newArrayList((Object[])new String[]{"javax.enterprise.event.Observes", "javax.enterprise.event.ObservesAsync", "javax.enterprise.inject.Disposes"});

    public boolean isImplicitUsage(PsiElement element) {
        Module module;
        if (element instanceof PsiModifierListOwner && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && CdiCommonUtils.isCdiInstalled(module)) {
            if (element instanceof PsiMethod) {
                for (PsiParameter parameter : ((PsiMethod)element).getParameterList().getParameters()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, PARAM_ANNOS)) continue;
                    return true;
                }
            }
            if (element instanceof PsiClass && CdiImplicitUsageProvider.isProducerClass((PsiClass)element)) {
                return true;
            }
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getBindingTypesQualifiedNames(module)) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getStereotypeAnnotationNames(module)) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"javax.enterprise.inject.Produces", (boolean)false) || CdiImplicitUsageProvider.isInjectedBeanCandidate(module, element);
        }
        return false;
    }

    private static boolean isProducerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return CdiCommonUtils.getProducerFields(psiClass).size() > 0 || CdiCommonUtils.getProducerMethods(psiClass).size() > 0;
    }

    private static boolean isInjectedBeanCandidate(@NotNull Module module, @NotNull PsiElement element) {
        if (module == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CdiImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass) {
            Set ipTypes = ContainerUtil.map2Set(CdiInjectionUtils.getInjectionPoints(module), descriptor -> descriptor.getType());
            for (PsiType ipType : ipTypes) {
                if (ipType == null || !ipType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)element)))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return this.isImplicitUsage(element);
    }

    public boolean isImplicitWrite(PsiElement element) {
        return this.isImplicitUsage(element) || element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"javax.inject.Inject", (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/providers/CdiImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isProducerClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectedBeanCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

