/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CdiStereotypeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(0);
        }
        if (aClass.isAnnotationType() && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Collections.singleton("javax.enterprise.inject.Stereotype"))) {
            CdiStereotypeInspection.checkStereotype(aClass, holder);
        }
    }

    private static void checkStereotype(PsiClass aClass, ProblemsHolder holder) {
        PsiAnnotation[] psiAnnotations;
        for (PsiAnnotation psiAnnotation : psiAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)aClass)) {
            if ("javax.inject.Named".equals(psiAnnotation.getQualifiedName())) {
                if (psiAnnotation.getParameterList().getAttributes().length == 0) continue;
                holder.registerProblem((PsiElement)psiAnnotation, CdiInspectionBundle.message("CdiStereotypeInspection.non.empty.named.annotations.not.allowed", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            holder.registerProblem((PsiElement)psiAnnotation, CdiInspectionBundle.message("CdiStereotypeInspection.qualified.annotations.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"javax.enterprise.inject.Typed"});
        if (annotation != null) {
            holder.registerProblem((PsiElement)annotation, CdiInspectionBundle.message("CdiStereotypeInspection.not.allowed.for.stereotypes", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.stereotype.errors", new Object[0]);
        if (string == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CdiStereotypeInspection" == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(3);
        }
        return "CdiStereotypeInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiStereotypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiStereotypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

