/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiScopeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiScopeInspection.$$$reportNull$$$0(0);
        }
        CdiScopeInspection.checkSingletonBeanScopes(psiClass, holder);
        CdiScopeInspection.checkStatelessSessionBeanScope(psiClass, holder);
    }

    private static void checkStatelessSessionBeanScope(PsiClass aClass, ProblemsHolder holder) {
        PsiIdentifier nameIdentifier;
        if (CdiScopeInspection.isSessionStatelessBean(aClass) && !CdiScopeInspection.isBeanOfScopeType(aClass, "javax.enterprise.context.Dependent") && (nameIdentifier = aClass.getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)nameIdentifier, CdiInspectionBundle.message("CdiScopeInspection.session.stateless.bean.incorrect.scopes", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isSessionStatelessBean(@NotNull PsiClass aClass) {
        if (aClass == null) {
            CdiScopeInspection.$$$reportNull$$$0(1);
        }
        for (EjbClassRole role : EjbHelper.getEjbHelper().getEjbRoles(aClass)) {
            EnterpriseBean bean = role.getEnterpriseBean();
            if (!(bean instanceof SessionBean)) continue;
            return SessionType.STATELESS.equals(((SessionBean)bean).getSessionType().getValue());
        }
        return false;
    }

    private static void checkSingletonBeanScopes(PsiClass psiClass, ProblemsHolder holder) {
        PsiAnnotation singletonAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.inject.Singleton"});
        if (singletonAnno != null && !CdiScopeInspection.isBeanOfScopeType(psiClass, "javax.enterprise.context.ApplicationScoped", "javax.enterprise.context.Dependent")) {
            holder.registerProblem((PsiElement)singletonAnno, CdiInspectionBundle.message("CdiScopeInspection.singleton.bean.incorrect.scopes", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isBeanOfScopeType(PsiClass psiClass, String ... scopeTypes) {
        PsiClass type = CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass).getScopeType();
        if (type != null) {
            String qualifiedName = type.getQualifiedName();
            for (String scopeType : scopeTypes) {
                if (!scopeType.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.bean.scope.inconsystency", new Object[0]);
        if (string == null) {
            CdiScopeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiScopeInspection" == null) {
            CdiScopeInspection.$$$reportNull$$$0(3);
        }
        return "CdiScopeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            CdiScopeInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiScopeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiScopeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSessionStatelessBean";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

