/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiManagedBeanInconsistencyInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (aClass.isAnnotationType() || CdiCommonUtils.isManagedBean(aClass) || CdiCommonUtils.isEnterpraiseCdiBean(aClass)) {
            return;
        }
        PsiIdentifier identifier = aClass.getNameIdentifier();
        if (identifier != null) {
            List<String> allAnnotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
            if (CdiCommonUtils.isClassContainsCdiAnnotations(aClass, allAnnotations)) {
                String unallowedAncestor;
                if (!CdiManagedBeanValidationUtils.hasAppropriateConstructor(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.no.appropriate.constructor", new Object[0]), new LocalQuickFix[0]);
                }
                if (!aClass.hasModifierProperty("abstract") && CdiManagedBeanValidationUtils.isParameterizedType(aClass) && !CdiManagedBeanInconsistencyInspection.isDependentScoped(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.parameterized.class", new Object[0]), new LocalQuickFix[0]);
                }
                if (CdiManagedBeanValidationUtils.isNonStaticInner(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.static.inner.class", new Object[0]), new LocalQuickFix[0]);
                }
                if ((unallowedAncestor = CdiManagedBeanValidationUtils.getUnallowedAncestor(aClass)) != null) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.unallowed.ancessor", unallowedAncestor), new LocalQuickFix[0]);
                }
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, allAnnotations) && !CdiManagedBeanValidationUtils.isConcreteClass(aClass) && !CdiManagedBeanValidationUtils.isDecoratorClass(aClass)) {
                holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.not.concrete.class", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isDependentScoped(@NotNull PsiClass aClass) {
        PsiClass type;
        if (aClass == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(1);
        }
        return (type = CdiDescriptorsFactory.createCdiBeanDescriptor(aClass).getScopeType()) != null && "javax.enterprise.context.Dependent".equals(type.getQualifiedName());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.managed.bean.inconsistency.errors", new Object[0]);
        if (string == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiManagedBeanInconsistencyInspection" == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(3);
        }
        return "CdiManagedBeanInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDependentScoped";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

