/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiAlternativeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        PsiAnnotation alternativeAnnotation;
        if (module == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(0);
        }
        if ((alternativeAnnotation = CdiAlternativeInspection.getAlternativeAnnotation(psiClass)) != null && CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            holder.registerProblem((PsiElement)alternativeAnnotation, CdiInspectionBundle.message("alternative.bean.should.not.be.vetoed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiAnnotation getAlternativeAnnotation(@NotNull PsiClass psiClass) {
        PsiAnnotation annotation;
        if (psiClass == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(1);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.enterprise.inject.Alternative"})) != null) {
            return annotation;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)));
        }
        return null;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.alternative.errors", new Object[0]);
        if (string == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiAlternativeInspection" == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(3);
        }
        return "CdiAlternativeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiAlternativeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiAlternativeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeAnnotation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

