/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCdiBeanDescriptor<T extends PsiMember>
implements CdiBeanDescriptor<T> {
    @NotNull
    public abstract T getAnnotatedItem();

    @Nullable
    protected abstract PsiClass getDefaultDeploymentType();

    @Override
    public Set<PsiClass> getQualifiers() {
        PsiClass defaultAnnotationClass;
        HashSet bindingTypes = new HashSet();
        Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(this.getModule()));
        Object[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
        if (annotations.length > 0) {
            bindingTypes.addAll(ContainerUtil.map2Set((Object[])annotations, psiAnnotation -> this.getAnnotationClass(psiAnnotation.getQualifiedName())));
        }
        if (!AnnotationUtil.isAnnotated(this.getAnnotatedItem(), (String)"javax.enterprise.inject.Specializes", (boolean)true) && (defaultAnnotationClass = this.getAnnotationClass("javax.enterprise.inject.Default")) != null) {
            bindingTypes.add(defaultAnnotationClass);
        }
        return bindingTypes;
    }

    @Override
    @Nullable
    public PsiClass getScopeType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getAnnotationClass("javax.enterprise.context.Dependent");
    }

    @Override
    @Nullable
    public PsiClass getDeploymentType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getDefaultDeploymentType();
    }

    @Override
    @NotNull
    public Set<PsiClass> getStereotypes() {
        HashSet stereotypes = new HashSet();
        Module module = this.getModule();
        if (module != null) {
            Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(module);
            T annotatedItem = this.getAnnotatedItem();
            for (PsiClass psiClass : stereotypeAnnotationClasses) {
                if (!AnnotationUtil.isAnnotated(annotatedItem, (String)psiClass.getQualifiedName(), (boolean)true)) continue;
                stereotypes.add(psiClass);
            }
        }
        HashSet hashSet = stereotypes;
        if (hashSet == null) {
            AbstractCdiBeanDescriptor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    protected PsiClass getAnnotationClass(@NotNull String annotation) {
        if (annotation == null) {
            AbstractCdiBeanDescriptor.$$$reportNull$$$0(1);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.getAnnotatedItem().getProject());
        Module module = this.getModule();
        GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.getAnnotatedItem().getProject()) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return psiFacade.findClass(annotation, scope);
    }

    @Nullable
    protected Module getModule() {
        return ModuleUtil.findModuleForPsiElement(this.getAnnotatedItem());
    }

    @Override
    public T getIdentifyingElement() {
        return this.getAnnotatedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/AbstractCdiBeanDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/AbstractCdiBeanDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

