/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9.mbeansModel;

import com.intellij.javaee.weblogic.agent.version9.mbeansModel.EditServiceWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DomainRuntimeServiceWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.RuntimeServiceWL9MBean;
import java.text.MessageFormat;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MBeansFactory {
    private static final String RUNTIME_SERVICE_MBEAN_TYPE = "weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String RUNTIME_SERVICE_MBEAN_NAME = "RuntimeService";
    private static final String DOMAIN_RUNTIME_SERVICE_MBEAN_TYPE = "weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean";
    private static final String DOMAIN_RUNTIME_SERVICE_MBEAN_NAME = "DomainRuntimeService";
    private static final String EDIT_SERVICE_MBEAN_TYPE = "weblogic.management.mbeanservers.edit.EditServiceMBean";
    private static final String EDIT_SERVICE_MBEAN_NAME = "EditService";
    private static final String OBJECT_NAME_PATTERN = "com.bea:Name={0},Type={1}";
    private static final String OBJECT_NAME_PATTERN_WITH_LOCATION = "com.bea:Name={0},Type={1},Location={2}";

    public static RuntimeServiceWL9MBean createRuntimeService(MBeanServerConnection connection, String serverName) throws JMException {
        ObjectName beanName = new ObjectName(MessageFormat.format(OBJECT_NAME_PATTERN_WITH_LOCATION, RUNTIME_SERVICE_MBEAN_NAME, RUNTIME_SERVICE_MBEAN_TYPE, serverName));
        return new RuntimeServiceWL9MBean(connection, beanName);
    }

    public static DomainRuntimeServiceWL9MBean createDomainRuntimeService(MBeanServerConnection connection) throws JMException {
        ObjectName name = new ObjectName(MessageFormat.format(OBJECT_NAME_PATTERN, DOMAIN_RUNTIME_SERVICE_MBEAN_NAME, DOMAIN_RUNTIME_SERVICE_MBEAN_TYPE));
        return new DomainRuntimeServiceWL9MBean(connection, name);
    }

    public static EditServiceWL9MBean createEditService(MBeanServerConnection connection) throws JMException {
        ObjectName name = new ObjectName(MessageFormat.format(OBJECT_NAME_PATTERN, EDIT_SERVICE_MBEAN_NAME, EDIT_SERVICE_MBEAN_TYPE));
        return new EditServiceWL9MBean(connection, name);
    }
}

