/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.run.localRun.ColoredScriptExecutableObject;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.run.localRun.ScriptHelper;
import com.intellij.javaee.run.localRun.ScriptUtil;
import com.intellij.javaee.run.localRun.ScriptsHelper;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.agent.WebLogicAgentUtil;
import com.intellij.javaee.weblogic.beaInstallation.BeaDomain;
import com.intellij.javaee.weblogic.beaInstallation.BeaServer;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class WeblogicStartupPolicy
implements ExecutableObjectStartupPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.weblogic.runDebug.configuration.WeblogicStartupPolicy");
    @NonNls
    private static final String SERVER_NAME_VARIABLE = "SERVER_NAME";
    @NonNls
    private static final String JAVA_OPTIONS_VARIABLE = "JAVA_OPTIONS";

    public EnvironmentHelper getEnvironmentHelper() {
        return new EnvironmentHelper(){

            public String getDefaultJavaVmEnvVariableName(CommonModel model) {
                return WeblogicStartupPolicy.JAVA_OPTIONS_VARIABLE;
            }

            public List<EnvironmentVariable> getAdditionalEnvironmentVariables(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>();
                if (weblogicModel.CONNECT_TO_MANAGED_SERVER) {
                    variables.add(new EnvironmentVariable(WeblogicStartupPolicy.JAVA_OPTIONS_VARIABLE, "-Dweblogic.management.username=" + weblogicModel.USERNAME + " -Dweblogic.management.password=" + weblogicModel.PASSWORD, true));
                }
                return variables;
            }
        };
    }

    private static String getAdminUrl(WeblogicModel weblogicModel) {
        return WebLogicAgentUtil.createAdminUrl(weblogicModel.getAdminServerHost(), weblogicModel.getAdminServerPort());
    }

    public ScriptHelper createStartupScriptHelper(ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                BeaDomain domain = weblogicModel.createDomain();
                File serverStartupScript = weblogicModel.CONNECT_TO_MANAGED_SERVER ? domain.getManagedServerStartupScript() : domain.getAdminServerStartupScript();
                String programParameters = null;
                if (weblogicModel.CONNECT_TO_MANAGED_SERVER) {
                    programParameters = weblogicModel.SERVER_NAME + " " + WeblogicStartupPolicy.getAdminUrl(weblogicModel);
                }
                return new ColoredCommandLineExecutableObject(new String[]{serverStartupScript.getAbsolutePath()}, programParameters);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createStartupScriptText(File serverStartupScript) throws ExecutionException {
        String string;
        if (!serverStartupScript.exists()) {
            throw new ExecutionException(WeblogicBundle.message("error.startup.script.not.found", serverStartupScript.getAbsolutePath()));
        }
        BufferedReader reader = new BufferedReader(new FileReader(serverStartupScript));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf("JAVA_OPTIONS=");
                if (index != -1 && line.indexOf(JAVA_OPTIONS_VARIABLE, index + 1) == -1) {
                    StringBuilder buffer = new StringBuilder(line);
                    buffer.append(' ');
                    ScriptUtil.appendEnvVariableReference((String)JAVA_OPTIONS_VARIABLE, (StringBuilder)buffer);
                    line = buffer.toString();
                }
                if (line.contains("SERVER_NAME=")) continue;
                builder.append(line).append(SystemProperties.getLineSeparator());
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                throw new ExecutionException(WeblogicBundle.message("error.cannot.create.startup.script", e.getMessage()));
            }
        }
        reader.close();
        return string;
    }

    public ScriptHelper createShutdownScriptHelper(ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel model) {
                WeblogicModel weblogicModel = (WeblogicModel)model.getServerModel();
                BeaDomain domain = weblogicModel.createDomain();
                File serverShutdownScript = weblogicModel.CONNECT_TO_MANAGED_SERVER ? domain.getManagedServerShutdownScript() : domain.getAdminServerShutdownScript();
                String userCredentials = weblogicModel.USERNAME + " " + weblogicModel.PASSWORD;
                if (!(serverShutdownScript == null || SystemInfo.isWindows && CommandLineUtil.hasWinShellSpecialChars((String)userCredentials))) {
                    String adminUrl = WeblogicStartupPolicy.getAdminUrl(weblogicModel);
                    String programParameters = weblogicModel.CONNECT_TO_MANAGED_SERVER ? weblogicModel.SERVER_NAME + " " + adminUrl + " " + userCredentials : userCredentials + " " + adminUrl;
                    return new ColoredCommandLineExecutableObject(new String[]{serverShutdownScript.getAbsolutePath()}, programParameters);
                }
                WeblogicVersion version = weblogicModel.getChosenVersion();
                if (version == null) {
                    return null;
                }
                BeaServer server = weblogicModel.getAdminServerConfiguration();
                StringBuilder result = new StringBuilder();
                if (SystemInfo.isWindows) {
                    result.append("@echo off\n");
                    result.append("SETLOCAL\n");
                }
                String wlHome = version.getInstallDir();
                String javaHome = version.getJavaHome();
                if (javaHome == null) {
                    Sdk projectJdk = ProjectRootManager.getInstance((Project)model.getProject()).getProjectSdk();
                    if (projectJdk == null) {
                        return null;
                    }
                    String homePath = projectJdk.getHomePath();
                    if (homePath == null) {
                        return null;
                    }
                    javaHome = FileUtil.toSystemDependentName((String)homePath);
                }
                ScriptUtil.appendEnvVariableDeclaration((String)"WL_HOME", (String)("\"" + wlHome + "\""), (StringBuilder)result);
                ScriptUtil.appendEnvVariableDeclaration((String)"JAVA_HOME", (String)("\"" + javaHome + "\""), (StringBuilder)result);
                ScriptUtil.appendEnvVariableDeclaration((String)"CLASSPATH", (String)version.getJarFile().getPath(), (StringBuilder)result);
                ScriptUtil.appendEnvVariableReference((String)"JAVA_HOME", (StringBuilder)result);
                result.append(File.separatorChar);
                result.append("bin");
                result.append(File.separatorChar);
                result.append("java weblogic.Admin -url localhost:");
                result.append(server.getPort());
                result.append(" -username ");
                result.append(weblogicModel.USERNAME);
                result.append(" -password ");
                result.append(weblogicModel.PASSWORD);
                result.append(" FORCESHUTDOWN ");
                result.append(server.getName());
                result.append("\n");
                if (SystemInfo.isWindows) {
                    result.append("ENDLOCAL");
                }
                return new ColoredScriptExecutableObject(result.toString(), "shutdown.");
            }
        };
    }

    public ScriptsHelper getStartupHelper() {
        return null;
    }

    public ScriptsHelper getShutdownHelper() {
        return null;
    }
}

