/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;

class DebugParameterChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.weblogic.runDebug.configuration.DebugParameterChecker");
    private final XmlFile myXmlFile;
    private final Project myProject;
    @NonNls
    private static final String ROOT_TAG_NAME = "weblogic-web-app";
    @NonNls
    private static final String JSP_DESCRIPTOR_TAG_NAME = "jsp-descriptor";
    @NonNls
    private static final String JSP_PARAM_TAG_NAME = "jsp-param";
    @NonNls
    private static final String PARAM_TAG_NAME = "param-name";
    @NonNls
    private static final String DEBUG = "debug";
    @NonNls
    private static final String PARAM_VALUE = "param-value";
    @NonNls
    private static final String TRUE = "true";

    public DebugParameterChecker(XmlFile xmlFile, Project project) {
        this.myProject = project;
        this.myXmlFile = xmlFile;
    }

    public boolean checkDebugParameter() {
        if (this.myXmlFile == null) {
            return false;
        }
        XmlDocument document = this.myXmlFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null || !ROOT_TAG_NAME.equals(rootTag.getName())) {
            return false;
        }
        XmlTag[] jspDescriptors = rootTag.findSubTags(JSP_DESCRIPTOR_TAG_NAME);
        boolean version9x = WeblogicEjbFacetUtil.isVersion9x(this.myXmlFile);
        for (XmlTag jspDescriptor : jspDescriptors) {
            XmlTag[] jspParams;
            if (version9x) {
                XmlTag tag = jspDescriptor.findFirstSubTag(DEBUG);
                if (tag == null || !TRUE.equals(tag.getValue().getTrimmedText())) continue;
                return true;
            }
            for (XmlTag jspParam : jspParams = jspDescriptor.findSubTags(JSP_PARAM_TAG_NAME)) {
                XmlTag subTag = jspParam.findFirstSubTag(PARAM_TAG_NAME);
                if (subTag == null || !DEBUG.equals(subTag.getValue().getTrimmedText())) continue;
                XmlTag paramValue = jspParam.findFirstSubTag(PARAM_VALUE);
                return paramValue != null && TRUE.equals(paramValue.getValue().getTrimmedText());
            }
        }
        return false;
    }

    public Runnable getQuickFix() {
        if (this.myXmlFile == null || this.myXmlFile.getDocument() == null || this.myXmlFile.getDocument().getRootTag() == null) {
            return null;
        }
        return new DebugParameterQuickFix();
    }

    private class DebugParameterQuickFix
    implements Runnable {
        private DebugParameterQuickFix() {
        }

        @Override
        public void run() {
            CommandProcessor.getInstance().executeCommand(DebugParameterChecker.this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> this.doFix()), WeblogicBundle.message("quickfix.name.debug.parameter.quickfix", new Object[0]), null);
        }

        private void doFix() {
            VirtualFile virtualFile = DebugParameterChecker.this.myXmlFile.getContainingFile().getVirtualFile();
            if (virtualFile != null && !virtualFile.isWritable() && !ReadonlyStatusHandler.getInstance((Project)DebugParameterChecker.this.myProject).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
                return;
            }
            try {
                XmlTag rootTag = DebugParameterChecker.this.myXmlFile.getDocument().getRootTag();
                if (!DebugParameterChecker.ROOT_TAG_NAME.equals(rootTag.getName())) {
                    rootTag.setName(DebugParameterChecker.ROOT_TAG_NAME);
                }
                this.createDescriptorIn(rootTag);
                XmlTag[] jspDescriptors = rootTag.findSubTags(DebugParameterChecker.JSP_DESCRIPTOR_TAG_NAME);
                boolean version9x = WeblogicEjbFacetUtil.isVersion9x(DebugParameterChecker.this.myXmlFile);
                if (version9x) {
                    XmlTag debugTag = this.findOrCreateDebugSubTag(jspDescriptors);
                    if (!DebugParameterChecker.TRUE.equals(debugTag.getValue().getTrimmedText())) {
                        debugTag.getValue().setText(DebugParameterChecker.TRUE);
                    }
                } else {
                    XmlTag debug = this.findOrCreateDebugJspParamValueIn(jspDescriptors);
                    if (!DebugParameterChecker.TRUE.equals(debug.getValue().getTrimmedText())) {
                        debug.replace((PsiElement)this.getFactory().createTagFromText(XmlTagUtil.composeTagText((String)DebugParameterChecker.PARAM_VALUE, (String)DebugParameterChecker.TRUE)));
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private XmlTag findOrCreateDebugSubTag(XmlTag[] jspDescriptors) throws IncorrectOperationException {
            for (XmlTag jspDescriptor : jspDescriptors) {
                XmlTag tag = jspDescriptor.findFirstSubTag(DebugParameterChecker.DEBUG);
                if (tag == null) continue;
                return tag;
            }
            XmlTag firstDescriptor = jspDescriptors[0];
            return (XmlTag)firstDescriptor.add((PsiElement)firstDescriptor.createChildTag(DebugParameterChecker.DEBUG, firstDescriptor.getNamespace(), DebugParameterChecker.TRUE, false));
        }

        private XmlTag findOrCreateDebugJspParamValueIn(XmlTag[] jspDescriptors) throws IncorrectOperationException {
            for (XmlTag jspDescriptor : jspDescriptors) {
                XmlTag[] jspParams;
                for (XmlTag jspParam : jspParams = jspDescriptor.findSubTags(DebugParameterChecker.JSP_PARAM_TAG_NAME)) {
                    XmlTag paramTag = jspParam.findFirstSubTag(DebugParameterChecker.PARAM_TAG_NAME);
                    if (paramTag == null || !DebugParameterChecker.DEBUG.equals(paramTag.getValue().getTrimmedText())) continue;
                    XmlTag valueSubTag = jspParam.findFirstSubTag(DebugParameterChecker.PARAM_VALUE);
                    if (valueSubTag != null) {
                        return valueSubTag;
                    }
                    XmlTag childTag = jspParam.createChildTag(DebugParameterChecker.PARAM_VALUE, jspParam.getNamespace(), DebugParameterChecker.TRUE, false);
                    return (XmlTag)jspParam.add((PsiElement)childTag);
                }
            }
            XmlTag firstDescriptor = jspDescriptors[0];
            XmlTag param = firstDescriptor.createChildTag(DebugParameterChecker.JSP_PARAM_TAG_NAME, firstDescriptor.getNamespace(), null, false);
            param = (XmlTag)firstDescriptor.add((PsiElement)param);
            param.add((PsiElement)param.createChildTag(DebugParameterChecker.PARAM_TAG_NAME, firstDescriptor.getNamespace(), DebugParameterChecker.DEBUG, false));
            XmlTag childTag = param.createChildTag(DebugParameterChecker.PARAM_VALUE, firstDescriptor.getNamespace(), DebugParameterChecker.TRUE, false);
            return (XmlTag)param.add((PsiElement)childTag);
        }

        private XmlElementFactory getFactory() {
            return XmlElementFactory.getInstance((Project)DebugParameterChecker.this.myProject);
        }

        private void createDescriptorIn(XmlTag rootTag) throws IncorrectOperationException {
            XmlTag[] jspDescriptors = rootTag.findSubTags(DebugParameterChecker.JSP_DESCRIPTOR_TAG_NAME);
            if (jspDescriptors.length == 0) {
                rootTag.add((PsiElement)rootTag.createChildTag(DebugParameterChecker.JSP_DESCRIPTOR_TAG_NAME, rootTag.getNamespace(), null, false));
            }
        }
    }
}

