/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.dataSource;

import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ServerInstance;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicDataSourceDescriptor;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicDataSourceProviderImpl
implements DataSourceProvider {
    private static final Logger LOG = Logger.getInstance(WeblogicDataSourceProviderImpl.class);

    @NotNull
    public DatabaseSystem createNewDataInstance(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            WeblogicDataSourceProviderImpl.$$$reportNull$$$0(0);
        }
        LocalDataSource localDataSource = new LocalDataSource();
        if (localDataSource == null) {
            WeblogicDataSourceProviderImpl.$$$reportNull$$$0(1);
        }
        return localDataSource;
    }

    @NotNull
    public List<LocalDataSource> loadDataSourcesFromServer(ServerInstance serverInstance) {
        JavaeeServerExtension serverExtension;
        JavaeeServerInstance javaeeServerInstance;
        WeblogicModel weblogicModel;
        ArrayList<LocalDataSource> result = new ArrayList<LocalDataSource>();
        if (serverInstance != null && (weblogicModel = (WeblogicModel)(javaeeServerInstance = (JavaeeServerInstance)serverInstance).getCommonModel().getServerModel()).isDatasourcesImportSupported() && (serverExtension = weblogicModel.getExtensionForDataSourceImport()) != null) {
            WebLogicAgentExtension agentExtension = (WebLogicAgentExtension)serverExtension.getAgentExtension();
            for (String dataSourceName : agentExtension.getConfiguredDataSourceNames()) {
                WeblogicDataSourceDescriptor descriptor = agentExtension.getDatasourceDescriptor(dataSourceName);
                if (descriptor == null) continue;
                result.add(new LocalDataSource(descriptor.getName(), descriptor.getDriverClassname(), descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword()));
            }
        }
        ArrayList<LocalDataSource> arrayList = result;
        if (arrayList == null) {
            WeblogicDataSourceProviderImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/weblogic/dataSource/WeblogicDataSourceProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/weblogic/dataSource/WeblogicDataSourceProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDataInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDataSourcesFromServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNewDataInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

