/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.beaInstallation;

import com.intellij.openapi.util.Comparing;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class WeblogicVersion {
    private final String myName;
    private final String myInstallDir;
    private final String myJavaHome;
    @NonNls
    private static final String SERVER_DIR = "server";
    @NonNls
    private static final String LIB_DIR = "lib";
    @NonNls
    private static final String WEBLOGIC_JAR = "weblogic.jar";
    @NonNls
    private static final String JXM_CLIENT_JAR_NAME = "wljmxclient.jar";
    @NonNls
    private static final String XBEAN_JAR_NAME = "xbean.jar";

    public WeblogicVersion(String name, String installDir, @Nullable String javaHome) {
        this.myName = name;
        this.myInstallDir = installDir;
        this.myJavaHome = javaHome;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.getName();
    }

    public String getInstallDir() {
        return this.myInstallDir;
    }

    public File getJarFile() {
        File libDir = this.getLibDir();
        return new File(libDir, WEBLOGIC_JAR);
    }

    public File getLibDir() {
        File serverDir = new File(this.myInstallDir, SERVER_DIR);
        return new File(serverDir, LIB_DIR);
    }

    public File getJMXClientJarFile() {
        return new File(this.getLibDir(), JXM_CLIENT_JAR_NAME);
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public File getXBeanJarFile() {
        return new File(this.getLibDir(), XBEAN_JAR_NAME);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof WeblogicVersion)) {
            return false;
        }
        WeblogicVersion other = (WeblogicVersion)obj;
        return this.myName.equals(other.myName) && this.myInstallDir.equals(other.myInstallDir) && Comparing.equal((String)this.myJavaHome, (String)other.myJavaHome);
    }
}

