/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.pool.BaseIndexPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.util.CharSequenceUtils;
import org.jf.util.CollectionUtils;

public class ProtoPool
extends BaseIndexPool<Key>
implements ProtoSection<CharSequence, CharSequence, Key, TypeListPool.Key<? extends Collection<? extends CharSequence>>> {
    @Nonnull
    private final StringPool stringPool;
    @Nonnull
    private final TypePool typePool;
    @Nonnull
    private final TypeListPool typeListPool;

    public ProtoPool(@Nonnull StringPool stringPool, @Nonnull TypePool typePool, @Nonnull TypeListPool typeListPool) {
        this.stringPool = stringPool;
        this.typePool = typePool;
        this.typeListPool = typeListPool;
    }

    public void intern(@Nonnull MethodReference method) {
        Key key = new Key(method);
        Integer prev = this.internedItems.put(key, 0);
        if (prev == null) {
            this.stringPool.intern(key.getShorty());
            this.typePool.intern(method.getReturnType());
            this.typeListPool.intern(method.getParameterTypes());
        }
    }

    @Override
    @Nonnull
    public CharSequence getShorty(@Nonnull Key key) {
        return key.getShorty();
    }

    @Override
    @Nonnull
    public CharSequence getReturnType(@Nonnull Key key) {
        return key.getReturnType();
    }

    @Override
    @Nullable
    public TypeListPool.Key<List<? extends CharSequence>> getParameters(@Nonnull Key key) {
        return new TypeListPool.Key<List<? extends CharSequence>>(key.getParameters());
    }

    public static class Key
    implements Comparable<Key> {
        @Nonnull
        private final MethodReference method;

        public Key(@Nonnull MethodReference method) {
            this.method = method;
        }

        @Nonnull
        public String getReturnType() {
            return this.method.getReturnType();
        }

        @Nonnull
        public List<? extends CharSequence> getParameters() {
            return this.method.getParameterTypes();
        }

        public String getShorty() {
            return MethodUtil.getShorty(this.method.getParameterTypes(), this.method.getReturnType());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (CharSequence charSequence : this.getParameters()) {
                sb.append(charSequence);
            }
            sb.append(')');
            sb.append(this.getReturnType());
            return sb.toString();
        }

        public int hashCode() {
            int hashCode = this.getReturnType().hashCode();
            return hashCode * 31 + CharSequenceUtils.listHashCode(this.getParameters());
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.getReturnType().equals(other.getReturnType()) && CharSequenceUtils.listEquals(this.getParameters(), other.getParameters());
            }
            return false;
        }

        @Override
        public int compareTo(@Nonnull Key o) {
            int res = this.getReturnType().compareTo(o.getReturnType());
            if (res != 0) {
                return res;
            }
            return CollectionUtils.compareAsIterable((Comparator)Ordering.usingToString(), this.getParameters(), o.getParameters());
        }
    }
}

