/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.IndexSection;
import org.jf.util.ExceptionWithContext;

public abstract class BaseIndexPool<Key>
implements IndexSection<Key> {
    @Nonnull
    protected final Map<Key, Integer> internedItems = Maps.newHashMap();

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends Key, Integer>> getItems() {
        return this.internedItems.entrySet();
    }

    @Override
    public int getItemIndex(@Nonnull Key key) {
        Integer index = this.internedItems.get(key);
        if (index == null) {
            throw new ExceptionWithContext("Item not found.: %s", new Object[]{this.getItemString(key)});
        }
        return index;
    }

    @Nonnull
    protected String getItemString(@Nonnull Key key) {
        return key.toString();
    }
}

