/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.highlight;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.ognl.OgnlTypes;
import com.intellij.lang.ognl.highlight.OgnlHighlightingLexer;
import com.intellij.lang.ognl.psi.OgnlTokenGroups;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OgnlHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    public static final TextAttributesKey BACKGROUND;
    public static final TextAttributesKey EXPRESSION_BOUNDS;
    public static final TextAttributesKey BAD_CHARACTER;
    public static final TextAttributesKey IDENTIFIER;
    public static final TextAttributesKey KEYWORDS;
    public static final TextAttributesKey OPERATIONS;
    public static final TextAttributesKey NUMBER;
    public static final TextAttributesKey STRING;
    public static final TextAttributesKey COMMA;
    public static final TextAttributesKey BRACKETS;
    public static final TextAttributesKey PARENTHESES;
    public static final TextAttributesKey BRACES;
    public static final TextAttributesKey FQN_TYPE;

    @NotNull
    public Lexer getHighlightingLexer() {
        OgnlHighlightingLexer ognlHighlightingLexer = new OgnlHighlightingLexer();
        if (ognlHighlightingLexer == null) {
            OgnlHighlighter.$$$reportNull$$$0(0);
        }
        return ognlHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType iElementType) {
        TextAttributesKey[] textAttributesKeyArray = OgnlHighlighter.pack((TextAttributesKey)BACKGROUND, (TextAttributesKey)keys1.get(iElementType));
        if (textAttributesKeyArray == null) {
            OgnlHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        BACKGROUND = TextAttributesKey.createTextAttributesKey((String)"OGNL.BACKGROUND", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        EXPRESSION_BOUNDS = TextAttributesKey.createTextAttributesKey((String)"OGNL.EXPRESSION", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"OGNL.BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"OGNL.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        KEYWORDS = TextAttributesKey.createTextAttributesKey((String)"OGNL.KEYWORDS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"OGNL.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)"OGNL.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        STRING = TextAttributesKey.createTextAttributesKey((String)"OGNL.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        COMMA = TextAttributesKey.createTextAttributesKey((String)"OGNL.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)"OGNL.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"OGNL.PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        BRACES = TextAttributesKey.createTextAttributesKey((String)"OGNL.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        FQN_TYPE = TextAttributesKey.createTextAttributesKey((String)"OGNL.FQN_TYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        keys1 = new HashMap<IElementType, TextAttributesKey>();
        keys1.put(TokenType.BAD_CHARACTER, BAD_CHARACTER);
        keys1.put(OgnlTypes.COMMA, COMMA);
        keys1.put(OgnlTypes.EXPRESSION_START, EXPRESSION_BOUNDS);
        keys1.put(OgnlTypes.EXPRESSION_END, EXPRESSION_BOUNDS);
        keys1.put(OgnlTypes.IDENTIFIER, IDENTIFIER);
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OgnlTokenGroups.KEYWORDS, (TextAttributesKey)KEYWORDS);
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OgnlTokenGroups.OPERATION_KEYWORDS, (TextAttributesKey)KEYWORDS);
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OgnlTokenGroups.OPERATION_SIGNS, (TextAttributesKey)OPERATIONS);
        keys1.put(OgnlTypes.DOLLAR, OPERATIONS);
        keys1.put(OgnlTypes.QUESTION, OPERATIONS);
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OgnlTokenGroups.NUMBERS, (TextAttributesKey)NUMBER);
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OgnlTokenGroups.TEXT, (TextAttributesKey)STRING);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        keys1.put(OgnlTypes.LBRACKET, BRACKETS);
        keys1.put(OgnlTypes.RBRACKET, BRACKETS);
        keys1.put(OgnlTypes.LPARENTH, PARENTHESES);
        keys1.put(OgnlTypes.RPARENTH, PARENTHESES);
        keys1.put(OgnlTypes.LBRACE, BRACES);
        keys1.put(OgnlTypes.RBRACE, BRACES);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(keys1, null);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(keys1, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/ognl/highlight/OgnlHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

