/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSAgentException;
import com.intellij.javaee.openshift.agent.cloud.OSApiTaskProvider;
import com.intellij.javaee.openshift.agent.cloud.OSAppSSHSessionFactory;
import com.intellij.javaee.openshift.agent.cloud.OSApplicationImpl;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentDeployment;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentImpl;
import com.intellij.javaee.openshift.agent.cloud.OSNewApplicationConfiguration;
import com.intellij.javaee.openshift.agent.cloud.PatchedRemoteSession;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import com.intellij.remoteServer.agent.util.log.TerminalPipe;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.GearProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.RemoteSession;

public class OSCloudAgentDeploymentImpl
implements OSCloudAgentDeployment {
    private static final int REMOTE_DEBUG_PORT = 8787;
    private final OSApiTaskProvider myTaskProvider;
    private final String myDeploymentName;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final LogAgentManager myLogManager;
    private final CloudAgentLogger myLogger;
    private final OSAppSSHSessionFactory mySessionFactory;
    private IApplicationPortForwarding myDebugPort;
    private int mySshSessionCounter;

    public OSCloudAgentDeploymentImpl(OSApiTaskProvider taskProvider, String deploymentName, CloudAgentLoggingHandler loggingHandler, LogAgentManager logManager, CloudAgentLogger logger, OSAppSSHSessionFactory sessionFactory) {
        this.myTaskProvider = taskProvider;
        this.myDeploymentName = deploymentName;
        this.myLoggingHandler = loggingHandler;
        this.myLogManager = logManager;
        this.myLogger = logger;
        this.mySessionFactory = sessionFactory;
        this.mySshSessionCounter = 0;
    }

    public CloudGitApplication createApplication() {
        return (CloudGitApplication)new OSApiTaskProvider.ApiTask<CloudGitApplication>(this.myTaskProvider){

            @Override
            protected CloudGitApplication doPerform(IDomain domain) throws OpenShiftException {
                IStandaloneCartridge defaultCartridge = OSCloudAgentImpl.getDefaultStandaloneCartridge(domain.getUser());
                return new OSApplicationImpl(domain.createApplication(OSCloudAgentDeploymentImpl.this.myDeploymentName, defaultCartridge));
            }
        }.perform();
    }

    public CloudGitApplication createApplication(final OSNewApplicationConfiguration appConfiguration) {
        OSApiTaskProvider oSApiTaskProvider = this.myTaskProvider;
        oSApiTaskProvider.getClass();
        return (CloudGitApplication)new OSApiTaskProvider.ApiTask<CloudGitApplication>(oSApiTaskProvider){

            @Override
            protected CloudGitApplication doPerform(IDomain domain) throws OpenShiftException {
                List cartridges = domain.getUser().getConnection().getStandaloneCartridges();
                IStandaloneCartridge standaloneCartridge = null;
                for (IStandaloneCartridge cartridge : cartridges) {
                    if (!cartridge.getName().equals(appConfiguration.getStandaloneCartridge())) continue;
                    standaloneCartridge = cartridge;
                }
                ApplicationScale scale = appConfiguration.isScaling() ? ApplicationScale.SCALE : ApplicationScale.NO_SCALE;
                GearProfile gearProfile = new GearProfile(appConfiguration.getGearSize());
                IApplication application = domain.createApplication(OSCloudAgentDeploymentImpl.this.myDeploymentName, standaloneCartridge, scale, (IGearProfile)gearProfile);
                for (String embCartridge : appConfiguration.getEmbeddableCartridges()) {
                    OSCloudAgentDeploymentImpl.this.addEmbeddableCartridge(domain, embCartridge, application);
                }
                return new OSApplicationImpl(application);
            }
        }.perform();
    }

    public void startDebugPortForwarding(final Integer localDebugPort) {
        OSApiTaskProvider oSApiTaskProvider = this.myTaskProvider;
        oSApiTaskProvider.getClass();
        new OSApiTaskProvider.ApiTask(oSApiTaskProvider){

            protected Object doPerform(IDomain domain) throws OpenShiftException, MalformedURLException, TransportException, OSAgentException {
                IApplication application = OSCloudAgentDeploymentImpl.this.getApplication(domain);
                if (!OSCloudAgentDeploymentImpl.this.setupAppSession(application)) {
                    throw new OSAgentException("Unable to create SSH session");
                }
                IApplicationPortForwarding debugPortForwarding = OSCloudAgentDeploymentImpl.findDebugPortForwarding(application);
                if (debugPortForwarding == null) {
                    throw new OSAgentException("Debug port forwarding not found");
                }
                Session sshSession = application.getSSHSession();
                debugPortForwarding.setLocalAddress("127.0.0.1");
                int localPort = localDebugPort != null ? localDebugPort.intValue() : debugPortForwarding.getRemotePort();
                debugPortForwarding.setLocalPort(localPort);
                if (!debugPortForwarding.isStarted(sshSession)) {
                    debugPortForwarding.start(sshSession);
                    OSCloudAgentDeploymentImpl.this.myDebugPort = debugPortForwarding;
                }
                return null;
            }
        }.perform();
    }

    public void stopDebugPortForwarding() {
        new OSApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(IDomain domain) throws OpenShiftException {
                OSCloudAgentDeploymentImpl.this.doStopDebugPortForwarding(domain);
                return null;
            }
        }.perform();
    }

    public void startSshSession() {
        new OSApiTaskProvider.ApiTask<Object>(this.myTaskProvider){

            @Override
            protected Object doPerform(IDomain domain) throws OpenShiftException, IOException, JSchException, URISyntaxException, OSAgentException {
                final OSSshPipe sshPipe = new OSSshPipe(domain);
                OSCloudAgentDeploymentImpl.this.myLogManager.startListeningLog("Ssh Session " + OSCloudAgentDeploymentImpl.this.mySshSessionCounter, new LogPipeProvider(){

                    public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                        return Collections.singletonList(sshPipe);
                    }
                });
                return null;
            }
        }.perform();
    }

    public void doStopDebugPortForwarding(IDomain domain) throws OpenShiftException {
        IApplication application = domain.getApplicationByName(this.myDeploymentName);
        if (application == null || !application.isPortFowardingStarted() || this.myDebugPort == null || !application.hasSSHSession()) {
            return;
        }
        Session sshSession = application.getSSHSession();
        this.myDebugPort.stop(sshSession);
        sshSession.disconnect();
    }

    private boolean setupAppSession(IApplication application) throws MalformedURLException, TransportException {
        if (!application.hasSSHSession()) {
            this.mySessionFactory.setupAppSession(application);
        }
        return application.hasSSHSession();
    }

    private static IApplicationPortForwarding findDebugPortForwarding(IApplication application) throws OpenShiftException {
        for (IApplicationPortForwarding port : application.refreshForwardablePorts()) {
            if (port.getRemotePort() != 8787) continue;
            return port;
        }
        return null;
    }

    public CloudGitApplication findApplication() {
        return (CloudGitApplication)new OSApiTaskProvider.ApiTask<CloudGitApplication>(this.myTaskProvider){

            @Override
            protected CloudGitApplication doPerform(IDomain domain) throws OpenShiftException {
                for (IApplication app : domain.getApplications()) {
                    if (!app.getName().equals(OSCloudAgentDeploymentImpl.this.myDeploymentName)) continue;
                    return new OSApplicationImpl(app);
                }
                return null;
            }
        }.perform();
    }

    private IApplication getApplication(IDomain domain) throws OSAgentException {
        IApplication result = domain.getApplicationByName(this.myDeploymentName);
        if (result == null) {
            throw new OSAgentException("Application not found");
        }
        return result;
    }

    public void deleteApplication() {
        new OSApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(IDomain domain) throws OpenShiftException, OSAgentException {
                OSCloudAgentDeploymentImpl.this.getApplication(domain).destroy();
                return null;
            }
        }.perform();
    }

    public CloudGitApplication findApplication4Repository(final String[] repositoryUrls) {
        OSApiTaskProvider oSApiTaskProvider = this.myTaskProvider;
        oSApiTaskProvider.getClass();
        return (CloudGitApplication)new OSApiTaskProvider.ApiTask<CloudGitApplication>(oSApiTaskProvider){

            @Override
            protected CloudGitApplication doPerform(IDomain domain) throws OpenShiftException {
                HashSet<String> urlsSet = new HashSet<String>(Arrays.asList(repositoryUrls));
                for (IApplication app : domain.getApplications()) {
                    if (!urlsSet.contains(app.getGitUrl())) continue;
                    return new OSApplicationImpl(app);
                }
                return null;
            }
        }.perform();
    }

    public void startListeningLog() {
        final List logFiles = (List)new OSApiTaskProvider.ApiSilentTask<List<String>>(this.myTaskProvider){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<String> doPerform(IDomain domain) throws OpenShiftException, IOException, OSAgentException {
                PatchedRemoteSession remoteSession = OSCloudAgentDeploymentImpl.this.getRemoteSession(domain);
                InputStream inputStream = OSCloudAgentDeploymentImpl.executeRemoteCommand((RemoteSession)remoteSession, "find */logs/* -name \"*.log\"");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    ArrayList<String> result = new ArrayList<String>();
                    while ((line = bufferedReader.readLine()) != null) {
                        result.add(line);
                    }
                    remoteSession.disconnect();
                    ArrayList<String> arrayList = result;
                    return arrayList;
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.perform();
        if (logFiles == null) {
            return;
        }
        this.myLogManager.startListeningLog(this.myDeploymentName, new LogPipeProvider(){

            public List<? extends LogPipe> createLogPipes(String deploymentName) {
                ArrayList<OSLogPipe> result = new ArrayList<OSLogPipe>();
                for (String logFile : logFiles) {
                    result.add(new OSLogPipe(deploymentName, logFile));
                }
                return result;
            }
        });
    }

    public void stopListeningLog() {
        this.myLogManager.stopListeningLog(this.myDeploymentName);
    }

    private void addEmbeddableCartridge(IDomain domain, String cartridgeName, IApplication application) throws OpenShiftException {
        List embeddableCartridges = domain.getUser().getConnection().getEmbeddableCartridges();
        for (IEmbeddableCartridge cartridge : embeddableCartridges) {
            if (!cartridge.getName().equals(cartridgeName)) continue;
            IEmbeddedCartridge embeddedCartridge = application.addEmbeddableCartridge(cartridge);
            this.myLogger.debug(embeddedCartridge.getCreationLog());
            this.myLoggingHandler.println(embeddedCartridge.getCreationLog());
        }
    }

    private PatchedRemoteSession getRemoteSession(IDomain domain) throws MalformedURLException, TransportException, OSAgentException {
        IApplication application = this.getApplication(domain);
        return this.mySessionFactory.getRemoteSession(application);
    }

    private static InputStream executeRemoteCommand(RemoteSession session, String command) throws IOException {
        Process process = session.exec(command, 0);
        return process.getInputStream();
    }

    private class OSSshPipe
    extends TerminalPipe {
        private final Process myProcess;

        public OSSshPipe(IDomain domain) throws IOException, OSAgentException {
            super("SSH session #" + ++OSCloudAgentDeploymentImpl.this.mySshSessionCounter, OSCloudAgentDeploymentImpl.this.myLoggingHandler);
            this.myProcess = OSCloudAgentDeploymentImpl.this.getRemoteSession(domain).startShell();
        }

        protected OutputStream getOutputStream() {
            return this.myProcess.getOutputStream();
        }

        protected InputStream getInputStream() {
            return this.myProcess.getInputStream();
        }

        public void close() {
            super.close();
            this.myProcess.destroy();
        }
    }

    private class OSLogPipe
    extends LogPipe {
        private final String myLogFilePath;

        public OSLogPipe(String deploymentName, String logFilePath) {
            super(deploymentName, logFilePath, OSCloudAgentDeploymentImpl.this.myLogger, OSCloudAgentDeploymentImpl.this.myLoggingHandler);
            this.myLogFilePath = logFilePath;
        }

        protected InputStream createInputStream(String deploymentName) {
            return (InputStream)new OSApiTaskProvider.ApiSilentTask<InputStream>(OSCloudAgentDeploymentImpl.this.myTaskProvider){

                @Override
                protected InputStream doPerform(IDomain domain) throws OpenShiftException, IOException, OSAgentException {
                    return OSCloudAgentDeploymentImpl.executeRemoteCommand((RemoteSession)OSCloudAgentDeploymentImpl.this.getRemoteSession(domain), "tail -c +1 -f " + OSLogPipe.this.myLogFilePath);
                }
            }.perform();
        }
    }
}

