/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OS3ApplicationBase;
import com.intellij.javaee.openshift.agent.cloud.OS3Context;
import com.intellij.javaee.openshift.agent.cloud.OS3PodImpl;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationProperty;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyImpl;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Service;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.ArrayList;
import java.util.List;

public class OS3ServiceImpl
extends OS3ApplicationBase
implements OS3Service {
    private OS3Pod[] myPods;

    public OS3ServiceImpl(IService service, OS3Context context) {
        super((IResource)service, context, OS3ServiceImpl.wrapSpecific(service));
        this.myPods = this.wrapPods(service.getPods());
    }

    public OS3Pod[] getPods() {
        return this.myPods;
    }

    private static OS3ApplicationProperty[] wrapSpecific(IService service) {
        return new OS3ApplicationProperty[]{new OS3ApplicationPropertyImpl("Container Port", String.valueOf(service.getPort())), new OS3ApplicationPropertyImpl("IP", service.getPortalIP()), new OS3ApplicationPropertyImpl("Selector", service.getSelector().toString())};
    }

    private OS3Pod[] wrapPods(List<IPod> pods) {
        ArrayList<OS3PodImpl> result = new ArrayList<OS3PodImpl>();
        for (IPod pod : pods) {
            result.add(new OS3PodImpl(pod, this.getContext()));
        }
        return result.toArray(new OS3Pod[result.size()]);
    }
}

